/************************************************************************************************
 *   深圳市摩西尔电子有限公司 @版本所有@
 *
 *   此文件用于模组参数页面逻辑
 *
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 徐烁超
 *      时间 : 2019.12.23
 *      内容 : 所有代码
 *************************************************************************************************/
/* exported mc_modwizd_construction_ui */
/* exported mc_modwizd_get_appearance */
/* exported mc_modwizd_updete_appearance */
/* exported mc_modwizd_dispose_mc_updata_appar */
/* exported mc_modwizd_get_hub */
/* exported mc_modwizd_get_level_type */
/* exported mc_modwizd_updata_level_type */
/* exported mc_modwizd_get_scan_cnt */
/* exported mc_modwizd_updata_scan_cnt */
/* exported mc_modwizd_get_clr */
/* exported mc_modwizd_updata_clr */
/* exported mc_modwizd_merge_ui_json */
/* exported mc_main_get_module_param_from_sdk */
/* exported mc_main_updata_module_param_from_sdk */
/* exported mc_wizard_apply_flow */
/* exported mc_mod_normol_msg */
/* exported mc_modwizd_updata_box_chip */

/* global mc_sdk_get_param */
/* global mc_pixtrace_scan_pix_data */
/* global mc_sdk_param */
/* global mc_sdk_module */
/* global $ */
/* global add_test_btn */
/* global mc_item_js_fun */
/* global set_fold_panel_display */
/* global mc_sdk_req_mgr */
/* global mc_layout_get_box_basic */

var JSON_PAPRAM_GET = "GET_PARAM";

var ERROR_CODE_KEY = "ERROR_CODE";
var JSON_REQ_NAME_ID_CTRLCHIP = "CTRLCHIP";

var JSON_NAMEID_DISPCHIP = "MC_LANG_DISPCHIP_LIST";
var JSON_NAMEID_SCANCHIP = "MC_LANG_SCANCHIP_LIST";
var JSON_ATTR_ID_UI_TYPE = "UI_TYPE";
var JSON_ATTR_ID_ARRAY = "ARRAY";
var JSON_TYPE_VALUE_OPTION = "OPTION";

/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    重构控件
 * 参数:
 *    @param {Promise<Object>} obj_item_grp 重构控件对象(不能为空)
 *    @param {Promise<string>} str_ui_id 重构页面id(不能为空)
 *    @param {Promise<string>} str_type 类型
 *    @param {Promise<object>} g_obj_lang 语言表(不能为空)
 *    @param {Promise<object>} obj_combo_mode 合并参数表(不能为空)
 *    @param {Promise<object>} obj_ui_json_res 更新数据(不能为空)
 *    @param {Promise<string>} ui_but_location 启用测试按钮下标(默认为有)
 * 返回：
 *    NA
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 徐烁超
 *      时间 : 2019.12.23
 *      内容 : 所有代码
 ************************************************************************************************/
function mc_modwizd_construction_ui(obj_item_grp, str_ui_id, str_type, g_obj_lang, obj_combo_mode, obj_ui_json_res, ui_but_location) {
    if ("object" !== typeof obj_item_grp) {
        return;
    }
    if ("string" !== typeof str_ui_id || 0 >= str_ui_id.length) {
        return;
    }
    if ("object" !== typeof g_obj_lang) {
        return;
    }
    if ("object" !== typeof obj_combo_mode) {
        return;
    }
    if ("object" !== typeof obj_ui_json_res) {
        return;
    }
    obj_item_grp.set_lang_map(g_obj_lang.get_item_map());
    obj_item_grp.set_rgb_combo_mode(obj_combo_mode);
    obj_item_grp.set_item_unit_width("5px");
    obj_item_grp.set_max_col_cnt(1);
    obj_item_grp.set_json_txt(JSON.stringify(
        obj_ui_json_res));
    $("#" + str_ui_id).html(obj_item_grp.get_dom_html());
    add_test_btn(str_ui_id, str_type, ui_but_location);
    set_fold_panel_display(str_ui_id);
    mc_item_js_fun();
}

/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    根据名称获取箱体或模组对应下标
 * 参数:
 *    @param {Promise<Array>} ary_data 储存模组或箱体的数组
 *    @param {Promise<string>} str_name 查询名称
 * 返回：
 *    @return {Promise<uint>} 对应名称所在下标
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 徐烁超
 *      时间 : 2020.9.8
 *      内容 : 所有代码
 ************************************************************************************************/
function mc_modwizd_get_idx_by_name(ary_data, str_name) {
    if (!Array.isArray(ary_data) || 0 >= ary_data.length) {
        return false;
    }
    if ("string" !== typeof str_name || 0 >= str_name.length) {
        return false;
    }
    var ui_idx = 0;

    for (var idx = 0; idx < ary_data.length; idx++) {
        if (!ary_data[idx].name) {
            return false;
        }
        if (ary_data[idx].name === str_name) {
            ui_idx = idx;
            break;
        }
    }
    return ui_idx;
}
/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    字符串截取
 * 参数:
 *    @param {Promise<string>} str_param 处理参数
 *    @param {Promise<string>} str_way 处理方式
 * 返回：
 *    @returns {Promise<Array>} 处理截取成功的数组,否则为空;
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 徐烁超
 *      时间 : 2019.12.23
 *      内容 : 所有代码
 ************************************************************************************************/
function mc_modwizd_splice_str(str_param, str_way) {
    if ("string" !== typeof str_param || 0 >= str_param.length) {
        return [];
    }
    if ("string" !== typeof str_way || 0 >= str_way.length) {
        return [];
    }
    if (-1 === str_param.indexOf(str_way)) {
        return [str_param];
    }
    return str_param.split(str_way);
}
/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    根据测试模组设置关于常规参数内容,获取对应返回值.
 * 参数:
 *    @param {Promise<Function>} fn_callback 回调函数
 * 返回：
 *    NA
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 徐烁超
 *      时间 : 2019.12.23
 *      内容 : 所有代码
 ************************************************************************************************/
function mc_mod_normol_msg(fn_callback) {
    mc_sdk_get_param(function (param_res) {
        var obj_normol_msg = new mc_sdk_param();

        obj_normol_msg.set_json(param_res);
        var obj_sdk_parma = new mc_sdk_param();

        obj_sdk_parma.set_json(parent.g_str_mod_normol_msg);
        obj_sdk_parma.set_param_value("GRAY_BIT_SIZE", obj_normol_msg.get_param_value("GRAY_BIT_SIZE"));
        parent.g_str_mod_normol_msg = obj_sdk_parma.get_json();
        fn_callback();
    });
}
/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    获取控制显示芯片列表 , 行管芯片列表
 * 参数:
 *    @param {Promise<string>} str_ctrlchip 主控芯片名称
 *    @param {Promise<function>} fun_callback 传入回调函数,不能为空(芯片列表ui_json对象)
 * 返回：
 *    NA
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 徐烁超
 *      时间 : 2019.11.21
 *      内容 : 所有代码
 ************************************************************************************************/
function mc_modwizd_construct_chiplist_ui_json(str_ctrlchip, fun_callback) {
    if ("function" !== typeof fun_callback) {
        return;
    }
    mc_modwizd_get_dispchip_list_by_sdk(str_ctrlchip, function (ary_dispchip) {
        if ("object" !== typeof ary_dispchip || 0 > ary_dispchip.length) {
            fun_callback("");
            return;
        }
        var str_dispchip = ary_dispchip[0];

        mc_modwizd_get_scanchip_list_by_sdk(str_ctrlchip, function (ary_scanchip) {
            if ("object" !== typeof ary_scanchip || 0 > ary_scanchip.length) {
                fun_callback("");
                return;
            }
            var str_scanchip = ary_scanchip[0];
            var str_ui_json_rsp = new mc_sdk_param();
            var str_disphip_options = "";
            var ui_chipcnt = "";
            var idx = 0;

            str_disphip_options = "";
            ui_chipcnt = ary_dispchip.length;
            idx = 0;

            for (idx = 0; idx < ui_chipcnt; idx++) {
                str_disphip_options += ary_dispchip[idx] + ",";
            }
            str_disphip_options = str_disphip_options.substring(0, str_disphip_options.length - 1);
            str_ui_json_rsp.set_param_value(JSON_NAMEID_DISPCHIP, str_dispchip);
            str_ui_json_rsp.set_attr_val(JSON_NAMEID_DISPCHIP, JSON_ATTR_ID_UI_TYPE, JSON_TYPE_VALUE_OPTION);
            str_ui_json_rsp.set_attr_val(JSON_NAMEID_DISPCHIP, JSON_ATTR_ID_ARRAY, str_disphip_options);

            str_disphip_options = "";
            ui_chipcnt = ary_scanchip.length;
            idx = 0;

            for (idx = 0; idx < ui_chipcnt; idx++) {
                str_disphip_options += ary_scanchip[idx] + ",";
            }
            str_disphip_options = str_disphip_options.substring(0, str_disphip_options.length - 1);
            str_ui_json_rsp.set_param_value(JSON_NAMEID_SCANCHIP, str_scanchip);
            str_ui_json_rsp.set_attr_val(JSON_NAMEID_SCANCHIP, JSON_ATTR_ID_UI_TYPE, JSON_TYPE_VALUE_OPTION);
            str_ui_json_rsp.set_attr_val(JSON_NAMEID_SCANCHIP, JSON_ATTR_ID_ARRAY, str_disphip_options);
            fun_callback(JSON.parse(str_ui_json_rsp.get_json()));
            return;
        });
    });
}

/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    获取显示芯片列表
 * 参数:
 *    @param {Promise<string>} str_ctrlchip 参数字串 传入控制芯片名称,不能为空
 *    @param {Promise<function>} fun_callback 传入回调函数(显示芯片列表数组)
 * 返回：
 *     NA
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 徐烁超
 *      时间 : 2019.11.21
 *      内容 : 所有代码
 ************************************************************************************************/
function mc_modwizd_get_dispchip_list_by_sdk(str_ctrlchip, fun_callback) {
    if ("function" !== typeof fun_callback) {
        return;
    }
    if ("string" !== typeof str_ctrlchip || 0 >= str_ctrlchip.length) {
        fun_callback("");
        return;
    }
    var str_item_json_req = new mc_sdk_param();

    str_item_json_req.set_param_clear();
    str_item_json_req.set_func("DISPCHIP_LIST");
    str_item_json_req.set_cmd(JSON_PAPRAM_GET);
    str_item_json_req.set_param_value(JSON_REQ_NAME_ID_CTRLCHIP, str_ctrlchip);
    $.post("/access_shell", str_item_json_req.get_json(), function (response, status) {
        if ("success" !== status) {
            fun_callback("");
            return;
        }
        var str_item_json_res = new mc_sdk_param();

        str_item_json_res.set_param_clear();
        str_item_json_res.set_json(response);

        var ui_ctrlchip_cnt = str_item_json_res.get_param_cnt();
        var ary_chip_name = [];

        for (var idx_chip = 0; idx_chip < ui_ctrlchip_cnt; idx_chip++) {
            var str_param_name = str_item_json_res.get_param_name(idx_chip);

            if (str_param_name.toUpperCase() === ERROR_CODE_KEY) {
                continue;
            }
            var str_chip_name = str_item_json_res.get_param_value(str_param_name);

            if ("string" !== typeof str_chip_name || 0 >= str_chip_name.length) {
                continue;
            }
            ary_chip_name.push(str_chip_name);
        }
        fun_callback(ary_chip_name);
        return;
    }, "text");
}

/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    获取行管芯片列表
 * 参数:
 *    @param {Promise<string>} str_ctrlchip 参数字串 传入控制芯片名称,不能为空
 *    @param {Promise<function>} fun_callback 传入回调函数,不能为空(行管芯片列表数组)
 * 返回：
 *    NA
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 徐烁超
 *      时间 : 2019.11.21
 *      内容 : 所有代码
 ************************************************************************************************/
function mc_modwizd_get_scanchip_list_by_sdk(str_ctrlchip, fun_callback) {
    if ("function" !== typeof fun_callback) {
        return;
    }
    if ("string" !== typeof str_ctrlchip || 0 >= str_ctrlchip.length) {
        fun_callback("");
        return;
    }
    var str_item_json_rsp = new mc_sdk_param();

    str_item_json_rsp.set_param_clear();
    str_item_json_rsp.set_func("SCANCHIP_LIST");
    str_item_json_rsp.set_cmd(JSON_PAPRAM_GET);
    str_item_json_rsp.set_param_value(JSON_REQ_NAME_ID_CTRLCHIP, str_ctrlchip);
    $.post("/access_shell", str_item_json_rsp.get_json(), function (response, status) {
        if ("success" !== status) {
            fun_callback("");
            return;
        }
        var str_item_json_req = new mc_sdk_param();

        str_item_json_req.set_param_clear();
        str_item_json_req.set_json(response);

        var ui_ctrlchip_cnt = str_item_json_req.get_param_cnt();
        var ary_chip_name = [];

        for (var idx_chip = 0; idx_chip < ui_ctrlchip_cnt; idx_chip++) {
            var str_param_name = str_item_json_req.get_param_name(idx_chip);

            if (str_param_name.toUpperCase() === ERROR_CODE_KEY) {
                continue;
            }
            var str_chip_name = str_item_json_req.get_param_value(str_param_name);

            if ("string" !== typeof str_chip_name || 0 >= str_chip_name.length) {
                continue;
            }
            ary_chip_name.push(str_chip_name);
        }
        fun_callback(ary_chip_name);
        return;
    }, "text");
}


/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    获取外观区域参数
 * 参数:
 *    @param {Promise<string>} str_mod_name 模组名称
 *    @param {Promise<Array>} ary_mod_data 储存所有数据的实例对象
 *    @param {Promise<string>} str_ctrlchip 主控芯片名称
 *    @param {Promise<object>} obj_info_data 注册信息管理对象
 *    @param {Promise<function>} fun_callback 传入回调函数,不能为空(外观区域参数)
 * 返回：
 *    NA
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 徐烁超
 *      时间 : 2019.12.23
 *      内容 : 所有代码
 ************************************************************************************************/
function mc_modwizd_get_appearance(str_mod_name, ary_mod_data, str_ctrlchip, obj_info_data, fun_callback) {
    if ("function" !== typeof fun_callback) {
        return;
    }
    var OBJ_SDK_PARAM_REQ = new mc_sdk_param();
    var OBJ_SDK_PARAM_RES = new mc_sdk_param();

    OBJ_SDK_PARAM_RES.set_param_clear();
    OBJ_SDK_PARAM_REQ.set_param_clear();
    var str_param_value = "";
    var str_param_name = "";
    var obj_sdk_module = new mc_sdk_module();

    if ("string" === typeof str_mod_name && 0 < str_mod_name.length) {
        for (var idx_mod = 0; idx_mod < ary_mod_data.length; idx_mod++) {
            if (ary_mod_data[idx_mod].name === str_mod_name) {
                obj_sdk_module = ary_mod_data[idx_mod].data;
                break;
            }
        }
    }
    var str_dispchip_name = obj_sdk_module.mc_util_mod_get_disp_chip();

    mc_modwizd_construct_chiplist_ui_json(str_ctrlchip, function (obj_chilplist_json) {
        OBJ_SDK_PARAM_RES.set_json(JSON.stringify(obj_chilplist_json));
        var ui_param_cnt = OBJ_SDK_PARAM_RES.get_param_cnt();

        for (var idx_param = 0; idx_param < ui_param_cnt; idx_param++) {
            str_param_name = OBJ_SDK_PARAM_RES.get_param_name(idx_param);
            str_param_value = OBJ_SDK_PARAM_RES.get_param_value(str_param_name);
            OBJ_SDK_PARAM_REQ.set_param_value(str_param_name, str_param_value);
            var ui_attr_cnt = OBJ_SDK_PARAM_RES.get_attr_cnt(str_param_name);

            for (var idx_attrs = 0; idx_attrs < ui_attr_cnt; idx_attrs++) {
                var str_attr_name = OBJ_SDK_PARAM_RES.get_attr_name(str_param_name,
                    idx_attrs);
                var str_attr_val = OBJ_SDK_PARAM_RES.get_attr_val(str_param_name, str_attr_name);

                OBJ_SDK_PARAM_REQ.set_attr_val(str_param_name, str_attr_name, str_attr_val);
            }
        }
        str_param_value = "64";
        OBJ_SDK_PARAM_REQ.set_param_value("MC_LANG_LABLE_WEITH", str_param_value);
        OBJ_SDK_PARAM_REQ.set_attr_val("MC_LANG_LABLE_WEITH", "UI_TYPE", "STEP_EDIT");
        OBJ_SDK_PARAM_REQ.set_attr_val("MC_LANG_LABLE_WEITH", "VAL_TYPE", "uint");
        OBJ_SDK_PARAM_REQ.set_attr_val("MC_LANG_LABLE_WEITH", "MIN_VAL", "1");
        OBJ_SDK_PARAM_REQ.set_attr_val("MC_LANG_LABLE_WEITH", "STEP", "16");
        str_param_value = "64";
        OBJ_SDK_PARAM_REQ.set_param_value("MC_LANG_LABLE_HEIGHT", str_param_value);
        OBJ_SDK_PARAM_REQ.set_attr_val("MC_LANG_LABLE_HEIGHT", "UI_TYPE", "STEP_EDIT");
        OBJ_SDK_PARAM_REQ.set_attr_val("MC_LANG_LABLE_HEIGHT", "VAL_TYPE", "uint");
        OBJ_SDK_PARAM_REQ.set_attr_val("MC_LANG_LABLE_HEIGHT", "MIN_VAL", "1");
        str_param_value = "2";
        OBJ_SDK_PARAM_REQ.set_param_value("MC_LANG_LABLE_TXGRP_CNT", str_param_value);
        OBJ_SDK_PARAM_REQ.set_attr_val("MC_LANG_LABLE_TXGRP_CNT", "UI_TYPE", "STEP_EDIT");
        OBJ_SDK_PARAM_REQ.set_attr_val("MC_LANG_LABLE_TXGRP_CNT", "VAL_TYPE", "uint");
        OBJ_SDK_PARAM_REQ.set_attr_val("MC_LANG_LABLE_TXGRP_CNT", "MIN_VAL", "1");
        str_param_value = "3";
        if (str_dispchip_name) {
            str_param_value = obj_sdk_module.mc_util_mod_get_str_grp_mode() + "";
        }
        OBJ_SDK_PARAM_REQ.set_param_value("MC_LANG_LABLE_TXGRP_MODE", str_param_value);
        if (1 === Number(str_param_value)) {
            str_param_value = obj_sdk_module.mc_util_mod_get_led_type() + "";

            OBJ_SDK_PARAM_REQ.set_param_value("MC_LANG_LABLE_LED_GRP_MODE", str_param_value);
            OBJ_SDK_PARAM_REQ.set_attr_val("MC_LANG_LABLE_LED_GRP_MODE", "UI_TYPE", "STEP_EDIT");
            OBJ_SDK_PARAM_REQ.set_attr_val("MC_LANG_LABLE_LED_GRP_MODE", "MIN_VAL", "1");
            OBJ_SDK_PARAM_REQ.set_attr_val("MC_LANG_LABLE_LED_GRP_MODE", "VAL_TYPE", "uint");
        }
        OBJ_SDK_PARAM_REQ.set_attr_val("MC_LANG_LABLE_TXGRP_MODE", "UI_TYPE", "OPTION");
        OBJ_SDK_PARAM_REQ.set_attr_val("MC_LANG_LABLE_TXGRP_MODE", "ARRAY", "1=MC_LANG_OPTION_STR_1_DSP,3=MC_LANG_OPTION_STR_3_DSP,4=MC_LANG_OPTION_STR_4_DSP");

        OBJ_SDK_PARAM_REQ.set_param_value("MC_LANG_LABLE_CLOSE_LOW_VALID", "0");
        OBJ_SDK_PARAM_REQ.set_attr_val("MC_LANG_LABLE_CLOSE_LOW_VALID", "UI_TYPE", "TOGGLE");
        OBJ_SDK_PARAM_REQ.set_attr_val("MC_LANG_LABLE_CLOSE_LOW_VALID", "SWITCH_TEXT", "YES,NO");
        if (str_dispchip_name) {
            mc_modwizd_dispose_sclk_type(obj_sdk_module, OBJ_SDK_PARAM_REQ);
            str_param_name = "MC_LANG_DISPCHIP_LIST";
            str_param_value = str_dispchip_name + "";
            OBJ_SDK_PARAM_REQ.set_param_value(str_param_name, str_param_value);
            str_param_name = "MC_LANG_SCANCHIP_LIST";
            str_param_value = obj_sdk_module.mc_util_mod_get_scan_chip() + "";
            OBJ_SDK_PARAM_REQ.set_param_value(str_param_name, str_param_value);

            var ui_mod_width = obj_sdk_module.mc_util_mod_get_width();
            var ui_mod_height = obj_sdk_module.mc_util_mod_get_height();

            if (
                0 >= ui_mod_width ||
                0 >= ui_mod_height
            ) {
                var obj_rect = obj_sdk_module.mc_util_mod_get_img_rect(0, 0xffffffff);

                ui_mod_width = (obj_rect.u32_right + 1 - obj_rect.u32_left);
                ui_mod_height = (obj_rect.u32_bottom + 1 - obj_rect.u32_top);
            }

            str_param_name = "MC_LANG_LABLE_WEITH";
            OBJ_SDK_PARAM_REQ.set_param_value(str_param_name, (ui_mod_width + ""));
            str_param_name = "MC_LANG_LABLE_HEIGHT";
            OBJ_SDK_PARAM_REQ.set_param_value(str_param_name, (ui_mod_height + ""));
            str_param_name = "MC_LANG_LABLE_CLOSE_LOW_VALID";
            str_param_value = obj_sdk_module.mc_util_mod_get_close_low_valid();
            var b_close_val = "0";

            if (str_param_value) {
                b_close_val = "1";
            }
            OBJ_SDK_PARAM_REQ.set_param_value(str_param_name, b_close_val);
            str_param_name = "MC_LANG_LABLE_TXGRP_CNT";
            var ui_str_cnt = obj_sdk_module.mc_util_mod_get_str_cnt();
            var ui_gro_mod = obj_sdk_module.mc_util_mod_get_str_grp_mode();

            str_param_value = Number(ui_str_cnt) / Number(ui_gro_mod) + "";
            OBJ_SDK_PARAM_REQ.set_param_value(str_param_name, str_param_value);
        } else {
            OBJ_SDK_PARAM_REQ.set_param_value("MC_LANG_LABLE_SCLK_2", "MC_LANG_OPTION_NOT_USE");
            OBJ_SDK_PARAM_REQ.set_attr_val("MC_LANG_LABLE_SCLK_2", "UI_TYPE", "OPTION");
            OBJ_SDK_PARAM_REQ.set_attr_val("MC_LANG_LABLE_SCLK_2", "ARRAY", "MC_LANG_OPTION_NOT_USE,LAT,OE(GCLK),A,B,C,D,E,F,UNDEF1,UNDEF2");
        }
        str_dispchip_name = OBJ_SDK_PARAM_REQ.get_param_value("MC_LANG_DISPCHIP_LIST");
        obj_info_data.set_chip_name(str_dispchip_name, str_ctrlchip);
        var obj_ui_json = OBJ_SDK_PARAM_REQ.get_json();

        obj_ui_json = JSON.parse(obj_ui_json);
        fun_callback(obj_ui_json);
    });
}

function mc_modwizd_dispose_sclk_type(obj_sdk_module, OBJ_SDK_PARAM_REQ) {
    var ui_sclk_cnt = obj_sdk_module.mc_util_mod_get_sclk_pin_cnt();
    var idx_sclk = 0;
    var ary_sclk_val = [];
    var ui_sclk_sub = 2;

    for (idx_sclk = 1; idx_sclk < ui_sclk_cnt; idx_sclk++) {
        var str_param_value = obj_sdk_module.mc_util_mod_get_sclk_pin_name(idx_sclk);

        if (-1 !== ary_sclk_val.indexOf(str_param_value)) {
            continue;
        }
        OBJ_SDK_PARAM_REQ.set_param_value("MC_LANG_LABLE_SCLK_" + ui_sclk_sub, str_param_value);
        OBJ_SDK_PARAM_REQ.set_attr_val("MC_LANG_LABLE_SCLK_" + ui_sclk_sub, "UI_TYPE", "OPTION");
        OBJ_SDK_PARAM_REQ.set_attr_val("MC_LANG_LABLE_SCLK_" + ui_sclk_sub, "ARRAY", "MC_LANG_OPTION_NOT_USE,LAT,OE(GCLK),A,B,C,D,E,F,UNDEF1,UNDEF2");
        ary_sclk_val.push(str_param_value);
        ui_sclk_sub++;
    }
    OBJ_SDK_PARAM_REQ.set_param_value("MC_LANG_LABLE_SCLK_" + ui_sclk_sub, "MC_LANG_OPTION_NOT_USE");
    OBJ_SDK_PARAM_REQ.set_attr_val("MC_LANG_LABLE_SCLK_" + ui_sclk_sub, "UI_TYPE", "OPTION");
    OBJ_SDK_PARAM_REQ.set_attr_val("MC_LANG_LABLE_SCLK_" + ui_sclk_sub, "ARRAY", "MC_LANG_OPTION_NOT_USE,LAT,OE(GCLK),A,B,C,D,E,F,UNDEF1,UNDEF2");
}

/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    更新外观区域参数
 * 参数:
 *    @param {Promise<string>} str_ui_json 页面数据生成的json字串
 *    @param {Promise<string>} str_ctrlchip 主控芯片名称
 *    @param {Promise<Object>} obj_info_data 注册信息管理对象
 *    @param {Promise<function>} fun_callback 传入回调函数,不能为空(外观区域参数)
 * 返回：
 *    NA
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 徐烁超
 *      时间 : 2019.12.23
 *      内容 : 所有代码
 ************************************************************************************************/
function mc_modwizd_updete_appearance(str_ui_json, str_ctrlchip, obj_info_data, fun_callback) {
    if ("function" !== typeof fun_callback) {
        return;
    }
    var obj_ui_param = new mc_sdk_param();

    if (!obj_ui_param.set_json(str_ui_json)) {
        fun_callback("");
        return;
    }
    // 获取显示芯片行管芯片
    mc_modwizd_construct_chiplist_ui_json(str_ctrlchip, function (obj_chilplist_json) {
        var obj_chilplist_param = new mc_sdk_param();

        obj_chilplist_param.set_json(JSON.stringify(obj_chilplist_json));
        var ui_chip_cnt = obj_chilplist_param.get_param_cnt();

        for (var idx_chip = 0; idx_chip < ui_chip_cnt; idx_chip++) {
            var str_chip_name = obj_chilplist_param.get_param_name(idx_chip);
            var ui_chip_list_cnt = obj_chilplist_param.get_attr_cnt(str_chip_name);
            var str_chip_val = "";

            for (var idx_chip_attr = 0; idx_chip_attr < ui_chip_list_cnt; idx_chip_attr++) {
                var str_chip_idx = obj_chilplist_param.get_attr_name(str_chip_name, idx_chip_attr);

                str_chip_val = obj_chilplist_param.get_attr_val(str_chip_name, str_chip_idx);
                obj_ui_param.set_attr_val(str_chip_name, str_chip_idx, str_chip_val);
            }
            // 判断此时的芯片是否存在,不存在使用列表第一个芯片参数
            var str_chip_value = obj_ui_param.get_param_value(str_chip_name);

            if (-1 === str_chip_val.indexOf(str_chip_value)) {
                var str_first_name = str_chip_val.split(",")[0];

                obj_ui_param.set_param_value(str_chip_name, str_first_name);
            }
        }
        var str_dispchip = obj_ui_param.get_param_value("MC_LANG_DISPCHIP_LIST");

        obj_info_data.set_chip_name(str_dispchip, str_ctrlchip);
        obj_info_data.get_info_json(function (str_disp_info_msg) {
            var obj_disp_info_msg = new mc_sdk_param();
            var str_ic_channels = "1";

            // 获取宽度步进值
            if (obj_disp_info_msg.set_json(str_disp_info_msg)) {
                str_ic_channels = obj_disp_info_msg.get_attr_val(str_dispchip, "IC_CHANNELS");
            }
            // 构造输出对象
            var obj_return = new mc_sdk_param();
            // 获取当前参数数量
            var ui_param_cnt = obj_ui_param.get_param_cnt();
            // 是否重构页面
            var b_is_construction = false;

            for (var idx_param = 0; idx_param < ui_param_cnt; idx_param++) {
                // NAME_IDX
                var str_param_name = obj_ui_param.get_param_name(idx_param);
                // VALUE
                var str_param_val = obj_ui_param.get_param_value(str_param_name);

                // 如果为多线并行不显示串行类型
                if ("MC_LANG_LABLE_LED_GRP_MODE" === str_param_name) {
                    var str_grp_mod = obj_ui_param.get_param_value("MC_LANG_LABLE_TXGRP_MODE");

                    if ("1" !== str_grp_mod) {
                        b_is_construction = true;
                        continue;
                    }
                }
                // set_param
                obj_return.set_param_value(str_param_name, str_param_val);
                // ATTRIBUE_CNT
                var ui_attrs_cnt = obj_ui_param.get_attr_cnt(str_param_name);

                for (var idx_attrs = 0; idx_attrs < ui_attrs_cnt; idx_attrs++) {
                    // ATTR_NAME
                    var str_attr_name = obj_ui_param.get_attr_name(str_param_name, idx_attrs);
                    // ATTR_VALUE
                    var str_attr_val = obj_ui_param.get_attr_val(str_param_name, str_attr_name);

                    // 修改宽度步进值
                    if ("MC_LANG_LABLE_WEITH" === str_param_name && "STEP" === str_attr_name) {
                        str_attr_val = str_ic_channels;
                    }
                    obj_return.set_attr_val(str_param_name, str_attr_name, str_attr_val);
                }

                // 如果为单线串行并且下一个参数不是串行类型 则加入串行类型
                if (
                    "1" === str_param_val &&
                    "MC_LANG_LABLE_TXGRP_MODE" === str_param_name &&
                    "MC_LANG_LABLE_LED_GRP_MODE" !== obj_ui_param.get_param_name((idx_param + 1))
                ) {
                    obj_return.set_param_value("MC_LANG_LABLE_LED_GRP_MODE", "1");
                    obj_return.set_attr_val("MC_LANG_LABLE_LED_GRP_MODE", "UI_TYPE", "STEP_EDIT");
                    obj_return.set_attr_val("MC_LANG_LABLE_LED_GRP_MODE", "MIN_VAL", "1  ");
                    obj_return.set_attr_val("MC_LANG_LABLE_LED_GRP_MODE", "VAL_TYPE", "uint");
                    b_is_construction = true;
                }
                // 如果获取到数据时钟并且为不使用则不使用之后的参数
                if (
                    -1 !== str_param_name.indexOf("MC_LANG_LABLE_SCLK") &&
                    "MC_LANG_OPTION_NOT_USE" === str_param_val &&
                    idx_param !== (ui_param_cnt - 1)
                ) {
                    b_is_construction = true;
                    break;
                }
            }
            // 最后的时钟属性值如果不是不使用则增加新的时钟选择
            var str_end_sclk_param_name = obj_ui_param.get_param_name((ui_param_cnt - 1));
            var str_end_sclk_param_value = obj_ui_param.get_param_value(str_end_sclk_param_name);

            if ("MC_LANG_OPTION_NOT_USE" !== str_end_sclk_param_value) {
                var str_sclk_end_idx = str_end_sclk_param_name.match(/\d+/g)[0];
                var str_new_sclk_name = "MC_LANG_LABLE_SCLK_" + (Number(str_sclk_end_idx) + 1);

                obj_return.set_param_value(str_new_sclk_name, "MC_LANG_OPTION_NOT_USE");
                obj_return.set_attr_val(str_new_sclk_name, "UI_TYPE", "OPTION");
                obj_return.set_attr_val(str_new_sclk_name, "ARRAY", "MC_LANG_OPTION_NOT_USE,LAT,OE(GCLK),A,B,C,D,E,F,UNDEF1,UNDEF2");
                b_is_construction = true;
            }

            var str_ui_json_req = obj_return.get_json();

            fun_callback(JSON.parse(str_ui_json_req), b_is_construction);
        });
    });
}

/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    获取时序极性参数
 * 参数:
 *    @param {Promise<string>} str_ui_json 外观区域参数
 *    @param {Promise<Object>} obj_info_data 注册信息管理对象
 *    @param {Promise<string>} str_mod_name 模组名称
 *    @param {Promise<string>} ary_mod_data 储存模组的数据
 *    @param {Promise<function>} fun_callback 传入回调函数,不能为空(时序极性参数)
 * 返回：
 *    NA
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 徐烁超
 *      时间 : 2019.12.23
 *      内容 : 所有代码
 ************************************************************************************************/
function mc_modwizd_get_level_type(str_ui_json, obj_info_data, str_mod_name, ary_mod_data, fun_callback) {
    if ("function" !== typeof fun_callback) {
        return;
    }
    if ("string" !== typeof str_ui_json || 0 >= str_ui_json.length) {
        fun_callback("");
        return;
    }
    var OBJ_SDK_PARAM_REQ = new mc_sdk_param();
    var OBJ_SDK_PARAM_RES = new mc_sdk_param();
    var obj_sdk_module = new mc_sdk_module();

    if ("string" === typeof str_mod_name && 0 < str_mod_name.length) {
        for (var idx_mod = 0; idx_mod < ary_mod_data.length; idx_mod++) {
            if (ary_mod_data[idx_mod].name === str_mod_name) {
                obj_sdk_module = ary_mod_data[idx_mod].data;
                break;
            }
        }
    }
    OBJ_SDK_PARAM_RES.set_param_clear();
    OBJ_SDK_PARAM_RES.set_json(str_ui_json);
    var str_dispchip = OBJ_SDK_PARAM_RES.get_param_value("MC_LANG_DISPCHIP_LIST");

    obj_info_data.get_info_json(function (str_register_json) {
        var str_val = "0";
        var obj_register_json = new mc_sdk_param();

        obj_register_json.set_param_clear();
        obj_register_json.set_json(str_register_json);

        OBJ_SDK_PARAM_REQ.set_param_clear();
        var str_tx_type = obj_register_json.get_attr_val(str_dispchip, "IGNORE_TX");
        var str_oe_type = obj_register_json.get_attr_val(str_dispchip, "IGNORE_OE");

        if ("string" !== typeof str_tx_type || "0" === str_tx_type) {
            if ("string" === typeof str_mod_name && 0 < str_mod_name.length) {
                str_val = obj_sdk_module.mc_util_mod_get_tx_low_valid();
                str_val = Number(str_val) + "";
            }
            OBJ_SDK_PARAM_REQ.set_param_value("MC_LANG_LABLE_TX_LOW_VALID", str_val);
            OBJ_SDK_PARAM_REQ.set_attr_val("MC_LANG_LABLE_TX_LOW_VALID", "UI_TYPE", "TOGGLE");
            OBJ_SDK_PARAM_REQ.set_attr_val("MC_LANG_LABLE_TX_LOW_VALID", "SWITCH_TEXT", "YES,NO");
        }
        if ("string" !== typeof str_oe_type || "0" === str_oe_type) {
            str_val = "1";
            if ("string" === typeof str_mod_name && 0 < str_mod_name.length) {
                str_val = obj_sdk_module.mc_util_mod_get_oe_low_valid();
                str_val = Number(str_val) + "";
            }
            OBJ_SDK_PARAM_REQ.set_param_value("MC_LANG_LABLE_OE_LOW_VALID", str_val);
            OBJ_SDK_PARAM_REQ.set_attr_val("MC_LANG_LABLE_OE_LOW_VALID", "UI_TYPE", "TOGGLE");
            OBJ_SDK_PARAM_REQ.set_attr_val("MC_LANG_LABLE_OE_LOW_VALID", "SWITCH_TEXT", "YES,NO");
        }
        var ui_param_cnt = OBJ_SDK_PARAM_REQ.get_param_cnt();

        if (0 >= ui_param_cnt) {
            fun_callback({});
            return;
        }
        var obj_ui_json_req = OBJ_SDK_PARAM_REQ.get_json();

        obj_ui_json_req = JSON.parse(obj_ui_json_req);
        fun_callback(obj_ui_json_req);
        return;
    });
}


/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    更新时序极性参数
 * 参数:
 *    @param {Promise<string>} str_appearance_json 外观区域参数
 *    @param {Promise<string>} str_level_type_json 时序极性区域参数
 *    @param {Promise<Object>} obj_info_data 注册信息管理对象
 *    @param {Promise<function>} fun_callback 传入回调函数,不能为空(时序极性参数)
 * 返回：
 *    NA
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 徐烁超
 *      时间 : 2019.12.23
 *      内容 : 所有代码
 ************************************************************************************************/
function mc_modwizd_updata_level_type(str_appearance_json, str_level_type_json, obj_info_data, fun_callback) {
    if ("function" !== typeof fun_callback) {
        return;
    }
    if ("string" !== typeof str_appearance_json || 0 >= str_appearance_json.length) {
        fun_callback("");
        return;
    }
    if ("string" !== typeof str_level_type_json || 0 >= str_level_type_json.length) {
        fun_callback("");
        return;
    }
    var OBJ_SDK_PARAM_RES = new mc_sdk_param();
    var b_construction = true;

    mc_modwizd_get_level_type(str_appearance_json, obj_info_data, "", [], function (obj_level_type) {
        var ary_obj_key = Object.keys(obj_level_type);
        var str_item_json = JSON.stringify(obj_level_type);

        if (0 >= ary_obj_key.length) {
            fun_callback({}, b_construction);
            return;
        }
        OBJ_SDK_PARAM_RES.set_param_clear();
        OBJ_SDK_PARAM_RES.set_json(str_level_type_json);
        var ui_ui_cnt = OBJ_SDK_PARAM_RES.get_param_cnt();

        OBJ_SDK_PARAM_RES.set_param_clear();
        OBJ_SDK_PARAM_RES.set_json(str_item_json);
        var ui_item_cnt = OBJ_SDK_PARAM_RES.get_param_cnt();
        var obj_ui_json = OBJ_SDK_PARAM_RES.get_json();

        obj_ui_json = JSON.parse(obj_ui_json);
        if (ui_ui_cnt === ui_item_cnt) {
            b_construction = false;
            fun_callback(obj_ui_json, b_construction);
            return;
        }
        fun_callback(obj_ui_json, b_construction);
        return;
    });
}

/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    获取行扫数
 * 参数:
 *    @param {Promise<Object>} obj_info_data 注册信息管理对象
 *    @param {Promise<string>} str_appearance_json 外观区域参数
 *    @param {Promise<string>} str_mod_name 模组名称
 *    @param {Promise<Array>} ary_mod_data 模组数据数组
 *    @param {Promise<function>} fun_callback 传入回调函数,不能为空(行扫数参数)
 * 返回：
 *    NA
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 徐烁超
 *      时间 : 2019.12.23
 *      内容 : 所有代码
 ************************************************************************************************/
function mc_modwizd_get_scan_cnt(obj_info_data, str_appearance_json, str_mod_name, ary_mod_data, fun_callback) {
    if ("function" !== typeof fun_callback) {
        return;
    }
    if ("string" !== typeof str_appearance_json || 0 >= str_appearance_json.length) {
        fun_callback({});
        return;
    }
    var OBJ_SDK_PARAM_RES = new mc_sdk_param();

    OBJ_SDK_PARAM_RES.set_param_clear();
    var str_scan_cnt = "";
    var str_dispchip = "";
    var obj_sdk_module = new mc_sdk_module();

    if ("string" === typeof str_mod_name && 0 < str_mod_name.length) {
        for (var idx_mod = 0; idx_mod < ary_mod_data.length; idx_mod++) {
            if (ary_mod_data[idx_mod].name === str_mod_name) {
                obj_sdk_module = ary_mod_data[idx_mod].data;
                break;
            }
        }
        str_dispchip = obj_sdk_module.mc_util_mod_get_disp_chip();
        str_scan_cnt = obj_sdk_module.mc_util_mod_get_scan_cnt_loc() + "";
    } else {
        OBJ_SDK_PARAM_RES.set_json(str_appearance_json);
        var ui_height_val = OBJ_SDK_PARAM_RES.get_param_value("MC_LANG_LABLE_HEIGHT");
        var ui_txgrp_cnt_val = OBJ_SDK_PARAM_RES.get_param_value("MC_LANG_LABLE_TXGRP_CNT");

        ui_height_val = parseInt(ui_height_val, 10);
        ui_txgrp_cnt_val = parseInt(ui_txgrp_cnt_val, 10);
        str_scan_cnt = ui_height_val / ui_txgrp_cnt_val;
        str_scan_cnt = mc_modwizd_splice_str(str_scan_cnt.toString(), ".");
        str_scan_cnt = str_scan_cnt[0];
        str_dispchip = OBJ_SDK_PARAM_RES.get_param_value("MC_LANG_DISPCHIP_LIST");
    }

    obj_info_data.get_info_json(function (info_json) {
        var obj_info_json = new mc_sdk_param();

        obj_info_json.set_json(info_json);
        var str_max_val = obj_info_json.get_attr_val(str_dispchip, "MAX_SCAN_ROWS");

        if (Number(str_scan_cnt) > Number(str_max_val)) {
            str_scan_cnt = str_max_val;
        }

        OBJ_SDK_PARAM_RES.set_param_clear();
        OBJ_SDK_PARAM_RES.set_param_value("MC_LANG_LABLE_SCAN_CNT", str_scan_cnt);
        OBJ_SDK_PARAM_RES.set_attr_val("MC_LANG_LABLE_SCAN_CNT", "UI_TYPE", "STEP_EDIT");
        OBJ_SDK_PARAM_RES.set_attr_val("MC_LANG_LABLE_SCAN_CNT", "MIN_VAL", "1");

        OBJ_SDK_PARAM_RES.set_attr_val("MC_LANG_LABLE_SCAN_CNT", "MAX_VAL", str_max_val);

        OBJ_SDK_PARAM_RES.set_attr_val("MC_LANG_LABLE_SCAN_CNT", "VAL_TYPE", "uint");
        OBJ_SDK_PARAM_RES.set_param_value("MC_LANG_LABLE_TEST_SCAN", "1");
        OBJ_SDK_PARAM_RES.set_attr_val("MC_LANG_LABLE_TEST_SCAN", "UI_TYPE", "STEP_EDIT");
        OBJ_SDK_PARAM_RES.set_attr_val("MC_LANG_LABLE_TEST_SCAN", "MIN_VAL", "1");
        OBJ_SDK_PARAM_RES.set_attr_val("MC_LANG_LABLE_TEST_SCAN", "VAL_TYPE", "uint");
        var obj_scan_json = OBJ_SDK_PARAM_RES.get_json();

        fun_callback(JSON.parse(obj_scan_json));
    });
}

/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    更新行扫数
 * 参数:
 *    @param {Promise<string>} str_appearance_json 外观区域参数
 *    @param {Promise<string>} str_scan_ui_json 行扫数区域参数
 *    @param {Promise<Object>} obj_info_data 注册信息管理对象
 *    @param {Promise<function>} fun_callback 传入回调函数,不能为空(行扫数参数)
 * 返回：
 *    NA
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 徐烁超
 *      时间 : 2019.12.23
 *      内容 : 所有代码
 ************************************************************************************************/
function mc_modwizd_updata_scan_cnt(str_appearance_json, str_scan_ui_json, obj_info_data, fun_callback) {
    if ("function" !== typeof fun_callback) {
        return;
    }
    if ("string" !== typeof str_appearance_json || 0 >= str_appearance_json.length) {
        fun_callback({});
        return;
    }
    if ("string" !== typeof str_scan_ui_json || 0 >= str_scan_ui_json.length) {
        fun_callback({});
        return;
    }
    var obj_appearance_json = new mc_sdk_param();

    obj_appearance_json.set_param_clear();
    obj_appearance_json.set_json(str_appearance_json);
    var ui_height_val = obj_appearance_json.get_param_value("MC_LANG_LABLE_HEIGHT");
    var str_dispchip_name = obj_appearance_json.get_param_value("MC_LANG_DISPCHIP_LIST");
    var ui_txgrp_cnt_val = obj_appearance_json.get_param_value("MC_LANG_LABLE_TXGRP_CNT");

    obj_info_data.get_info_json(function (info_json) {
        var obj_info_json = new mc_sdk_param();

        obj_info_json.set_param_clear();
        obj_info_json.set_json(info_json);
        var str_max_val = obj_info_json.get_attr_val(str_dispchip_name, "MAX_SCAN_ROWS");
        var str_scan_cnt = "";

        ui_height_val = Number(ui_height_val);
        ui_txgrp_cnt_val = Number(ui_txgrp_cnt_val);
        str_scan_cnt = ui_height_val / ui_txgrp_cnt_val;
        str_scan_cnt = parseInt(str_scan_cnt, 10) + "";

        if (Number(str_scan_cnt) > Number(str_max_val)) {
            str_scan_cnt = str_max_val;
        }

        var obj_scan_json = new mc_sdk_param();

        obj_scan_json.set_param_clear();
        obj_scan_json.set_json(str_scan_ui_json);
        obj_scan_json.set_param_value("MC_LANG_LABLE_SCAN_CNT", str_scan_cnt);

        obj_scan_json.set_attr_val("MC_LANG_LABLE_SCAN_CNT", "MAX_VAL", str_max_val);
        var obj_ui_json = obj_scan_json.get_json();

        obj_ui_json = JSON.parse(obj_ui_json);
        fun_callback(obj_ui_json);
    });
}

/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    获取灯串颜色
 * 参数:
 *    @param {Promise<string>} str_appearance_json 外观区域参数
 *    @param {Promise<string>} str_mod_name 模组名称
 *    @param {Promise<Array>} ary_mod_data 模组数据数组
 *    @param {Promise<function>} fun_callback 传入回调函数,不能为空(灯串颜色区域参数)
 * 返回：
 *    NA
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 徐烁超
 *      时间 : 2019.12.23
 *      内容 : 所有代码
 ************************************************************************************************/
function mc_modwizd_get_clr(str_appearance_json, str_mod_name, ary_mod_data, fun_callback) {
    if ("function" !== typeof fun_callback) {
        return;
    }
    if ("string" !== typeof str_appearance_json || 0 >= str_appearance_json.length) {
        fun_callback("");
        return;
    }
    var OBJ_SDK_PARAM_RES = new mc_sdk_param();
    var str_clr_1 = "R";
    var str_clr_2 = "G";
    var str_clr_3 = "B";
    var str_clr_4 = "R";
    var obj_sdk_module = new mc_sdk_module();

    if ("string" === typeof str_mod_name && 0 < str_mod_name.length) {
        for (var idx_mod = 0; idx_mod < ary_mod_data.length; idx_mod++) {
            if (ary_mod_data[idx_mod].name === str_mod_name) {
                obj_sdk_module = ary_mod_data[idx_mod].data;
                break;
            }
        }
    }

    OBJ_SDK_PARAM_RES.set_param_clear();
    OBJ_SDK_PARAM_RES.set_json(str_appearance_json);
    var obj_clr_json = {};
    var str_group_type = OBJ_SDK_PARAM_RES.get_param_value("MC_LANG_LABLE_TXGRP_MODE");
    var ary_clr_val = [str_clr_1, str_clr_2, str_clr_3, str_clr_4];

    OBJ_SDK_PARAM_RES.set_param_clear();
    if ("string" === typeof str_mod_name && 0 < str_mod_name.length) {
        ary_clr_val = JSON.parse(JSON.stringify(obj_sdk_module.mc_util_mod_get_clr_msg()));
    }
    for (var idx_clr = 0; idx_clr < ary_clr_val.length; idx_clr++) {
        switch (ary_clr_val[idx_clr]) {
            case "R":
                ary_clr_val[idx_clr] = "1";
                break;
            case "G":
                ary_clr_val[idx_clr] = "2";
                break;
            case "B":
                ary_clr_val[idx_clr] = "3";
                break;
            default:
                ary_clr_val[idx_clr] = "4";
                break;
        }
    }

    str_clr_1 = ary_clr_val[0];
    str_clr_2 = ary_clr_val[1];
    str_clr_3 = ary_clr_val[2];
    str_clr_4 = ary_clr_val[3];
    OBJ_SDK_PARAM_RES.set_param_value("MC_LANG_LABLE_COLOR_1", str_clr_1);
    OBJ_SDK_PARAM_RES.set_attr_val("MC_LANG_LABLE_COLOR_1", "UI_TYPE", "RADIO");
    OBJ_SDK_PARAM_RES.set_attr_val("MC_LANG_LABLE_COLOR_1", "ARRAY", "1=MC_LANG_OPTION_CLR_R,2=MC_LANG_OPTION_CLR_G,3=MC_LANG_OPTION_CLR_B,4=MC_LANG_OPTION_CLR_V");

    OBJ_SDK_PARAM_RES.set_param_value("MC_LANG_LABLE_COLOR_2", str_clr_2);
    OBJ_SDK_PARAM_RES.set_attr_val("MC_LANG_LABLE_COLOR_2", "UI_TYPE", "RADIO");
    OBJ_SDK_PARAM_RES.set_attr_val("MC_LANG_LABLE_COLOR_2", "ARRAY", "1=MC_LANG_OPTION_CLR_R,2=MC_LANG_OPTION_CLR_G,3=MC_LANG_OPTION_CLR_B,4=MC_LANG_OPTION_CLR_V");

    OBJ_SDK_PARAM_RES.set_param_value("MC_LANG_LABLE_COLOR_3", str_clr_3);
    OBJ_SDK_PARAM_RES.set_attr_val("MC_LANG_LABLE_COLOR_3", "UI_TYPE", "RADIO");
    OBJ_SDK_PARAM_RES.set_attr_val("MC_LANG_LABLE_COLOR_3", "ARRAY", "1=MC_LANG_OPTION_CLR_R,2=MC_LANG_OPTION_CLR_G,3=MC_LANG_OPTION_CLR_B,4=MC_LANG_OPTION_CLR_V");

    if ("4" === str_group_type) {
        OBJ_SDK_PARAM_RES.set_param_value("MC_LANG_LABLE_COLOR_4", str_clr_4);
        OBJ_SDK_PARAM_RES.set_attr_val("MC_LANG_LABLE_COLOR_4", "UI_TYPE", "RADIO");
        OBJ_SDK_PARAM_RES.set_attr_val("MC_LANG_LABLE_COLOR_4", "ARRAY", "1=MC_LANG_OPTION_CLR_R,2=MC_LANG_OPTION_CLR_G,3=MC_LANG_OPTION_CLR_B,4=MC_LANG_OPTION_CLR_V");
    }
    obj_clr_json = OBJ_SDK_PARAM_RES.get_json();

    obj_clr_json = JSON.parse(obj_clr_json);
    fun_callback(obj_clr_json);
    return;
}

/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    更新灯串颜色
 * 参数:
 *    @param {Promise<string>} str_appearance_json 外观区域参数
 *    @param {Promise<string>} str_clr_ui_json 灯串颜色区域参数
 *    @param {Promise<function>} fun_callback 传入回调函数,不能为空(灯串颜色区域参数)
 * 返回：
 *    NA
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 徐烁超
 *      时间 : 2019.12.23
 *      内容 : 所有代码
 ************************************************************************************************/
function mc_modwizd_updata_clr(str_appearance_json, str_clr_ui_json, fun_callback) {
    if ("function" !== typeof fun_callback) {
        return;
    }
    if ("string" !== typeof str_appearance_json || 0 >= str_appearance_json.length) {
        fun_callback("");
        return;
    }
    var OBJ_SDK_PARAM_REQ = new mc_sdk_param();
    var OBJ_SDK_PARAM_RES = new mc_sdk_param();

    OBJ_SDK_PARAM_RES.set_param_clear();
    OBJ_SDK_PARAM_RES.set_json(str_appearance_json);
    var b_construction = false;
    var obj_clr_json = {};
    var str_group_type = OBJ_SDK_PARAM_RES.get_param_value("MC_LANG_LABLE_TXGRP_MODE");

    OBJ_SDK_PARAM_RES.set_param_clear();
    OBJ_SDK_PARAM_RES.set_json(str_clr_ui_json);
    if ("4" !== str_group_type) {
        var ui_param_cnt = OBJ_SDK_PARAM_RES.get_param_cnt();

        if (4 === ui_param_cnt) {
            b_construction = true;
            OBJ_SDK_PARAM_REQ.set_param_clear();

            for (var idx_param = 0; idx_param < ui_param_cnt; idx_param++) {
                if (idx_param === ui_param_cnt - 1) {
                    break;
                }
                var str_param_name = OBJ_SDK_PARAM_RES.get_param_name(idx_param);
                var str_param_value = OBJ_SDK_PARAM_RES.get_param_value(str_param_name);

                OBJ_SDK_PARAM_REQ.set_param_value(str_param_name, str_param_value);
                var ui_attr_cnt = OBJ_SDK_PARAM_RES.get_attr_cnt(str_param_name);

                for (var idx_attr = 0; idx_attr < ui_attr_cnt; idx_attr++) {
                    var str_attr_name = OBJ_SDK_PARAM_RES.get_attr_name(str_param_name, idx_attr);
                    var str_attr_val = OBJ_SDK_PARAM_RES.get_attr_val(str_param_name, str_attr_name);

                    OBJ_SDK_PARAM_REQ.set_attr_val(str_param_name, str_attr_name, str_attr_val);
                }
            }
            obj_clr_json = OBJ_SDK_PARAM_REQ.get_json();
            obj_clr_json = JSON.parse(obj_clr_json);
        }
        fun_callback(obj_clr_json, b_construction);
        return;
    }
    OBJ_SDK_PARAM_RES.set_param_value("MC_LANG_LABLE_COLOR_4", "1");
    OBJ_SDK_PARAM_RES.set_attr_val("MC_LANG_LABLE_COLOR_4", "UI_TYPE", "RADIO");
    OBJ_SDK_PARAM_RES.set_attr_val("MC_LANG_LABLE_COLOR_4", "ARRAY", "1=MC_LANG_OPTION_CLR_R,2=MC_LANG_OPTION_CLR_G,3=MC_LANG_OPTION_CLR_B,4=MC_LANG_OPTION_CLR_V");
    obj_clr_json = OBJ_SDK_PARAM_RES.get_json();

    obj_clr_json = JSON.parse(obj_clr_json);
    b_construction = true;
    fun_callback(obj_clr_json, b_construction);
    return;
}

/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    构造基本箱体链接信息,存入箱体数据数组中
 * 参数:
 *    @param {Promise<string>} str_ctrlchip_name 参数字串 控制芯片名称,不能为空
 *    @param {Promise<string>} str_hub_name 参数字串 Hub接口名称
 *    @param {Promise<string>} str_mod_name 参数字串 模组名称
 *    @param {Promise<String>} str_mod_msg 参数字串 模组信息
 *    @param {Promise<Array>} ary_mod_data 模组数据
 *    @param {Promise<Array>} ary_box_data 箱体数据数组
 *    @param {Promise<String>} str_ctrlchip_hub 主控芯片HUB接口数据
 * 返回：
 *    @returns {Promise<boolean>} 储存结果
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 徐烁超
 *      时间 : 2020-4-10
 *      内容 : 所有代码
 ************************************************************************************************/
function mc_modwizd_access_set_box_file(str_ctrlchip_name, str_hub_name, str_mod_name, str_mod_msg, ary_mod_data, ary_box_data, str_ctrlchip_hub) {
    if ("string" !== typeof str_ctrlchip_name || 0 >= str_ctrlchip_name.length) {
        return false;
    }
    if ("string" !== typeof str_hub_name || 0 >= str_hub_name.length) {
        return false;
    }
    var obj_sdk_param = new mc_sdk_param();
    var obj_ui_box = parent.mc_data_box();

    if (!obj_sdk_param.set_json(str_mod_msg)) {
        return false;
    }

    var obj_box_msg = {};

    obj_box_msg.data = [
        {
            jx_num: "1",
            children: [
                {
                    module_name: str_mod_name,
                    mirror: "0",
                    offset_x: "0",
                    offset_y: "0",
                    rotation: "0,0,0",
                    scale: "0.0,0.0,1.0,1.0"

                }
            ]
        }
    ];
    obj_box_msg.ctrlchip_name = str_ctrlchip_name;
    obj_box_msg.hub_name = str_hub_name;
    obj_ui_box.mc_util_set_ui_box_msg(obj_box_msg);
    var obj_box_data = {
        name: "MC_BOX_0",
        data: obj_ui_box,
        ctrlchip_hub_msg: str_ctrlchip_hub
    };

    ary_box_data.push(obj_box_data);
    return true;
}


/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    合并字串
 * 参数:
 *    @param {Promise<Array>} ary_data 需要合并起来的子串或对象组成的数组
 * 返回：
 *    @returns {Promise<object>} 将数据合并起来的param对象
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 徐烁超
 *      时间 : 2019.11.22
 *      内容 : 所有代码
 ************************************************************************************************/
function mc_modwizd_merge_ui_json(ary_data) {
    if (!(Array.isArray(ary_data)) || 0 >= ary_data.length) {
        return false;
    }
    var obj_mod_msg = new mc_sdk_param();
    var obj_sdk_param = new mc_sdk_param();

    obj_sdk_param.set_param_clear();
    obj_mod_msg.set_param_clear();

    for (var idx = 0; idx < ary_data.length; idx++) {
        var str_ui_json = ary_data[idx];

        if ("string" !== typeof str_ui_json) {
            str_ui_json = JSON.stringify(str_ui_json);
        }
        obj_sdk_param.set_param_clear();
        obj_sdk_param.set_json(str_ui_json);
        var ui_param_cnt = obj_sdk_param.get_param_cnt();

        for (var idx_param = 0; idx_param < ui_param_cnt; idx_param++) {
            var str_param_name = obj_sdk_param.get_param_name(idx_param);
            var str_param_val = obj_sdk_param.get_param_value(str_param_name);

            obj_mod_msg.set_param_value(str_param_name, str_param_val);
            var ui_attr_cnt = obj_sdk_param.get_attr_cnt(str_param_name);

            for (var idx_attr = 0; idx_attr < ui_attr_cnt; idx_attr++) {
                var str_attr_name = obj_sdk_param.get_attr_name(str_param_name, idx_attr);
                var str_attr_val = obj_sdk_param.get_attr_val(str_param_name, str_attr_name);

                obj_mod_msg.set_attr_val(str_param_name, str_attr_name, str_attr_val);
            }
        }
    }

    return obj_mod_msg;
}

/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    获取芯片信息
 * 参数:
 *    @param {Promise<function>} fun_callback 传入回调函数,不能为空(箱体信息ui_json对象)
 * 返回：
 *    NA
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 徐烁超
 *      时间 : 2020.4.4
 *      内容 : 所有代码
 ************************************************************************************************/
function mc_main_get_module_param_from_sdk(fun_callback) {
    if ("function" !== typeof fun_callback) {
        return;
    }
    var obj_sdk_param = new mc_sdk_param();

    obj_sdk_param.set_param_clear();
    mc_main_get_ctrlchip_list_by_sdk(function (ary_ctrlchip) {
        var str_ctrlchip_name = ary_ctrlchip[0];
        var str_disphip_options = "";

        for (var idx = 0; idx < ary_ctrlchip.length; idx++) {
            str_disphip_options += ary_ctrlchip[idx] + ",";
        }
        str_disphip_options = str_disphip_options.substring(0, str_disphip_options.length - 1);
        obj_sdk_param.set_param_value("MC_LANG_CTRLCHIP_LIST", str_ctrlchip_name);
        obj_sdk_param.set_attr_val("MC_LANG_CTRLCHIP_LIST", "UI_TYPE", "OPTION");
        obj_sdk_param.set_attr_val("MC_LANG_CTRLCHIP_LIST", "ARRAY", str_disphip_options);
        obj_sdk_param.set_param_value("MC_LANG_LABLE_HUB", str_ctrlchip_name);
        obj_sdk_param.set_attr_val("MC_LANG_LABLE_HUB", "UI_TYPE", "OPTION");
        obj_sdk_param.set_attr_val("MC_LANG_LABLE_HUB", "ARRAY", str_ctrlchip_name);
        fun_callback(JSON.parse(obj_sdk_param.get_json()));
        return;
    });
}

/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    获取控制芯片列表
 * 参数:
 *    @param {Promise<function>} fun_callback 传入回调函数,不能为空(控制芯片列表数组)
 * 返回：
 *    NA
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 徐烁超
 *      时间 : 2020.4.4
 *      内容 : 所有代码
 ************************************************************************************************/
function mc_main_get_ctrlchip_list_by_sdk(fun_callback) {
    if ("function" !== typeof fun_callback) {
        return;
    }
    var obj_request = new mc_sdk_req_mgr();
    var str_item_json_req = new mc_sdk_param();

    str_item_json_req.set_func("CTRLCHIP_LIST");
    str_item_json_req.set_cmd("GET_PARAM");
    obj_request.push_req(str_item_json_req.get_json(), function (response, status) {
        if ("success" !== status) {
            fun_callback("");
            return;
        }
        var str_item_json_res = new mc_sdk_param();

        str_item_json_res.set_json(response);

        var ui_ctrlchip_param_cnt = str_item_json_res.get_param_cnt();
        var ary_ctrlchip = [];

        for (var idx_chip = 0; idx_chip < ui_ctrlchip_param_cnt; idx_chip++) {
            var str_param_name = str_item_json_res.get_param_name(idx_chip);

            if ("ERROR_CODE" === str_param_name.toUpperCase()) {
                continue;
            }
            var str_chip_name = str_item_json_res.get_param_value(str_param_name);

            if ("string" !== typeof str_chip_name || 0 >= str_chip_name.length) {
                continue;
            }
            ary_ctrlchip.push(str_chip_name);
        }
        fun_callback(ary_ctrlchip);
        return;
    });
}

/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    更新hub芯片
 * 参数:
 *    @param {Promise<object>} obj_ui_json 芯片信息数据对象,不能为空
 *    @param {Promise<function>} fun_callback 传入回调函数,不能为空(芯片信息数据对象)
 * 返回：
 *    NA
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 徐烁超
 *      时间 : 2019.11.21
 *      内容 : 所有代码
 ************************************************************************************************/
function mc_main_updata_module_param_from_sdk(obj_ui_json, fun_callback) {
    if ("function" !== typeof fun_callback) {
        return;
    }
    if ("object" !== typeof obj_ui_json) {
        fun_callback("");
        return;
    }
    var obj_sdk_param = new mc_sdk_param();

    obj_sdk_param.set_param_clear();
    obj_sdk_param.set_json(JSON.stringify(obj_ui_json));
    var str_ctrlchip_name = obj_sdk_param.get_param_value("MC_LANG_CTRLCHIP_LIST");
    var str_ctrl = obj_sdk_param.get_param_value("MC_LANG_CTRLCHIP_LIST");

    mc_main_get_hub(str_ctrlchip_name, function (str_hub_list) {
        var ary_hub_list = mc_main_splice_str(str_hub_list, ",");
        var str_param_val = obj_sdk_param.get_param_value("MC_LANG_LABLE_HUB");

        if (-1 === ary_hub_list.indexOf(str_param_val)) {
            str_param_val = ary_hub_list[0];
        }

        if ("T6" === str_ctrl) {
            if (-1 !== ary_hub_list.indexOf("T-75E")) {
                str_param_val = "T-75E";
            }
        }

        obj_sdk_param.set_param_value("MC_LANG_LABLE_HUB", str_param_val);
        obj_sdk_param.set_attr_val("MC_LANG_LABLE_HUB", "ARRAY", str_hub_list);
        var obj_ui_json_req = obj_sdk_param.get_json();

        obj_ui_json_req = JSON.parse(obj_ui_json_req);
        fun_callback(obj_ui_json_req);
        return;
    });
}

/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    获取HUB列表
 * 参数:
 *    @param {Promise<string>} str_ctrlchip_name 控制芯片名称,不能为空
 *    @param {Promise<function>} fun_callback 传入回调函数,不能为空(HUB列表)
 * 返回：
 *    NA
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 徐烁超
 *      时间 : 2019.12.23
 *      内容 : 所有代码
 ************************************************************************************************/
function mc_main_get_hub(str_ctrlchip_name, fun_callback) {
    if ("string" !== typeof str_ctrlchip_name || 0 >= str_ctrlchip_name.length) {
        fun_callback("");
        return;
    }
    if ("function" !== typeof fun_callback) {
        return;
    }
    var obj_sdk_param_req = new mc_sdk_param();

    obj_sdk_param_req.set_param_clear();
    obj_sdk_param_req.set_cmd("GET_PARAM");
    obj_sdk_param_req.set_func("RECVHUB_LIST");
    obj_sdk_param_req.set_param_value("CTRLCHIP", str_ctrlchip_name);
    $.post("/access_shell", obj_sdk_param_req.get_json(), function (response, status) {
        if ("success" !== status) {
            fun_callback("");
            return;
        }
        obj_sdk_param_req.set_param_clear();
        obj_sdk_param_req.set_json(response);
        var str_hub_list = obj_sdk_param_req.get_param_value(str_ctrlchip_name);

        if ("string" !== typeof str_hub_list || 0 >= str_hub_list.length) {
            fun_callback(str_ctrlchip_name);
            return;
        }
        fun_callback(str_hub_list);
        return;
    });
}

/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    字符串截取
 * 参数:
 *    @param {Promise<string>} str_param 处理参数
 *    @param {Promise<string>} str_way 处理方式
 * 返回：
 *    @return {Promise<Array>} 截取后生成的数组;
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 徐烁超
 *      时间 : 2020.4.4
 *      内容 : 所有代码
 ************************************************************************************************/
function mc_main_splice_str(str_param, str_way) {
    if ("string" !== typeof str_param || 0 >= str_param.length) {
        return [];
    }
    if (-1 === str_param.indexOf(str_way)) {
        return [str_param];
    }
    return str_param.split(str_way);
}

/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    解析模组信息,存入模组数据数组中
 * 参数:
 *    @param {promises<String>} str_module_msg 模组基本信息
 *    @param {promises<string>} str_info_msg 芯片注册信息
 *    @param {promises<Array>} ary_mod_data 模组数据数组
 *    @param {promises<String>} str_updata_mod_name 已知模组名称(有名称则更新当前名称下的模组信息)
 *    @param {promises<Array>} ary_dot 页面数据(没有的话使用默认走点)
 *    @param {promises<Boolean>} b_is_more 走点模式(多线/单线)
 * 返回：
 *    @returns {Promise<String>} 解析成功的模组名称
 * 备注:
 *   因为多线走点与单线走点生成的数据不同,但结果数据相同,故使用此函数统一化,将数据修改相同
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 徐烁超
 *      时间 : 2020.5.6
 *      内容 : 所有代码
 ************************************************************************************************/
function mc_use_msg_set_module_xml(str_module_msg, str_info_msg, ary_mod_data, str_updata_mod_name, ary_dot) {
    var obj_sdk_param = new mc_sdk_param();
    var obj_module_info = new mc_sdk_param();

    if (
        !obj_sdk_param.set_json(str_module_msg) ||
        !obj_module_info.set_json(str_info_msg)
    ) {
        parent.mc_alert_popout("MC_LANG_MC_SET_MOD_SIZE_ERR_GET_INFO_ALL_FAIL");
        return false;
    }
    var obj_sdk_module = parent.mc_data_module();

    // 模组宽度
    var ui_mod_w = Number(obj_sdk_param.get_param_value("MC_LANG_LABLE_WEITH"));
    // 模组高度
    var ui_mod_h = Number(obj_sdk_param.get_param_value("MC_LANG_LABLE_HEIGHT"));
    // 模组设置的行扫数
    var ui_scan_cnt = Number(obj_sdk_param.get_param_value("MC_LANG_LABLE_SCAN_CNT"));
    // 模组数据组类型
    var ui_grp_mod = Number(obj_sdk_param.get_param_value("MC_LANG_LABLE_TXGRP_MODE"));
    // 模组数据组数
    var ui_grp_cnt = Number(obj_sdk_param.get_param_value("MC_LANG_LABLE_TXGRP_CNT"));
    // 串行类型
    var ui_gry_type = Number(obj_sdk_param.get_param_value("MC_LANG_LABLE_LED_GRP_MODE"));
    // 显示芯片名称
    var str_dispchip_name = obj_sdk_param.get_param_value("MC_LANG_DISPCHIP_LIST");
    // 行管芯片名称
    var str_scan_chip_name = obj_sdk_param.get_param_value("MC_LANG_SCANCHIP_LIST");
    // CLOSE有效性
    var str_close_vaild = Number(obj_sdk_param.get_param_value("MC_LANG_LABLE_CLOSE_LOW_VALID"));
    // OE有效性
    var str_oe_vaild = Number(obj_sdk_param.get_param_value("MC_LANG_LABLE_OE_LOW_VALID"));
    // TX有效性
    var str_tx_vaild = Number(obj_sdk_param.get_param_value("MC_LANG_LABLE_TX_LOW_VALID"));
    // 时钟数量
    var ui_clock_cnt = mc_modwizd_get_mod_clock_cnt(obj_sdk_param);
    // 获取模组颜色
    var ary_color = mc_quick_get_mod_color(obj_sdk_param);
    // 模组跳点值
    var ui_step_val = 1;
    // 跳点标识
    var ui_jump_ic = Number(obj_module_info.get_attr_val(str_dispchip_name, "JUMP_IC"));
    // 芯片通道数
    var ui_ic_channels = Number(obj_module_info.get_attr_val(str_dispchip_name, "IC_CHANNELS"));

    if (!ary_color) {
        return false;
    }

    // 获取模组灯珠数,只有串行模式使用
    var ui_led_cnt = ui_gry_type * ui_clock_cnt;

    if (ui_led_cnt > (ui_mod_w * (Math.floor(ui_mod_h / ui_grp_mod)) / ui_scan_cnt)) {
        parent.mc_alert_popout("MC_LANG_LED_CNT_ERROR");
        return false;
    }
    // 将页面已知走点解析
    var ary_dot_data = mc_get_module_point_class(ary_dot, ary_color, ui_ic_channels, ui_led_cnt, ui_grp_mod, ui_grp_cnt, ui_scan_cnt, ui_mod_w, ui_mod_h);

    if (!ary_dot_data) {
        parent.mc_alert_popout("MC_LANG_MC_SET_MOD_WALK_POINT_ERR");
        return ary_dot_data;
    }

    mc_set_mod_msg();
    var ui_save_idx = ary_mod_data.length;
    var str_module_name = "";

    if (str_updata_mod_name) {
        str_module_name = str_updata_mod_name;
        for (var idx_mod = 0; idx_mod < ary_mod_data.length; idx_mod++) {
            if (ary_mod_data[idx_mod].name === str_updata_mod_name) {
                ui_save_idx = idx_mod;
                continue;
            }
            var str_mod_json = ary_mod_data[idx_mod].data.mc_util_mod_get_xml();

            if (obj_sdk_module.mc_util_mod_check_equal(str_mod_json)) {
                parent.mc_alert_popout("MC_LANG_MOD_EXIST");
                return false;
            }
        }
    } else {
        str_module_name = mc_get_module_name(obj_sdk_module, ary_mod_data);
        if (!str_module_name) {
            return false;
        }
    }

    obj_sdk_module.mc_util_mod_set_led_name(str_module_name);
    var obj_module_data = {
        data: obj_sdk_module,
        name: str_module_name
    };

    ary_mod_data[ui_save_idx] = obj_module_data;
    return str_module_name;

    function mc_set_mod_msg() {
        // 存入 显示 / 行管芯片名称 模组分组模式 串行类型 颜色信息 行扫数
        obj_sdk_module.mc_util_mod_set_str_grp_mode(ui_grp_mod);
        obj_sdk_module.mc_util_mod_set_disp_chip(str_dispchip_name);
        obj_sdk_module.mc_util_mod_set_scan_chip(str_scan_chip_name);
        obj_sdk_module.mc_util_mod_set_width(ui_mod_w);
        obj_sdk_module.mc_util_mod_set_height(ui_mod_h);
        obj_sdk_module.mc_util_mod_set_scan_cnt(ui_scan_cnt);
        obj_sdk_module.mc_util_mod_set_led_type(ui_gry_type);
        obj_sdk_module.mc_util_mod_set_clr_msg(ary_color);

        if ("string" !== typeof obj_sdk_param.get_param_value("MC_LANG_LABLE_OE_LOW_VALID")) {
            str_oe_vaild = true;
        }
        obj_sdk_module.mc_util_mod_set_oe_low_valid(str_oe_vaild);
        obj_sdk_module.mc_util_mod_set_tx_low_valid(str_tx_vaild);
        obj_sdk_module.mc_util_mod_set_close_low_valid(str_close_vaild);
        // 存入时钟
        obj_sdk_module.mc_util_mod_set_sclk_pin_name(0, "SCLK");
        var ui_param_cnt = obj_sdk_param.get_param_cnt();

        for (var idx_clock = 2; idx_clock < ui_param_cnt; idx_clock++) {
            var str_clock_val = obj_sdk_param.get_param_value(("MC_LANG_LABLE_SCLK_" + idx_clock));

            if ("MC_LANG_OPTION_NOT_USE" === str_clock_val) {
                break;
            }
            obj_sdk_module.mc_util_mod_set_sclk_pin_name((idx_clock - 1), str_clock_val);
        }

        if (1 === ui_jump_ic) {
            ui_step_val = ui_ic_channels;
        }
        obj_sdk_module.mc_util_mod_set_scan_pix_step(ui_step_val);
        obj_sdk_module.mc_util_mod_set_jump_ic(ui_jump_ic.toString());
        obj_sdk_module.mc_util_mod_set_ic_channels(ui_ic_channels.toString());
        for (var idx_str = 0; idx_str < ary_dot_data.length; idx_str++) {
            var ary_scan_val = ary_dot_data[idx_str];

            obj_sdk_module.mc_util_mod_set_str_name(idx_str, "STR_" + idx_str);
            obj_sdk_module.mc_util_mod_set_str_pin(idx_str, "STR_" + idx_str);
            for (var idx_scan = 0; idx_scan < ary_scan_val.length; idx_scan++) {
                var ary_pix_val = ary_scan_val[idx_scan];
                var ui_pix_cnt = ary_pix_val.length;

                for (var idx_pix = ui_pix_cnt - 1; 0 <= idx_pix; idx_pix--) {
                    var ui_img_x = ary_pix_val[idx_pix].img_x;
                    var ui_img_y = ary_pix_val[idx_pix].img_y;
                    var str_color = ary_pix_val[idx_pix].color;
                    var ui_pix_idx = (ui_pix_cnt - 1) - idx_pix;

                    obj_sdk_module.mc_util_mod_set_pix_info(idx_str, idx_scan, ui_pix_idx, ui_img_x, ui_img_y, str_color);
                }
            }
        }
    }
}

// 获取模组时钟数量
function mc_modwizd_get_mod_clock_cnt(obj_sdk_param) {
    if (
        "function" !== typeof obj_sdk_param.get_param_cnt ||
        "function" !== typeof obj_sdk_param.get_param_name ||
        "function" !== typeof obj_sdk_param.get_param_value
    ) {
        return 1;
    }
    var ui_param_cnt = obj_sdk_param.get_param_cnt();
    var ui_clock_cnt = 1;

    for (var idx_param = 0; idx_param < ui_param_cnt; idx_param++) {
        var str_param_name = obj_sdk_param.get_param_name(idx_param);
        var str_param_value = obj_sdk_param.get_param_value(str_param_name);

        if (
            -1 !== str_param_name.indexOf("MC_LANG_LABLE_SCLK") &&
            "MC_LANG_OPTION_NOT_USE" !== str_param_value
        ) {
            ui_clock_cnt++;
        }
    }
    return ui_clock_cnt;
}

// 解析模组信息存入模组信息(走点数据若有已知走点则解析,无则使用默认走点))
function mc_get_module_point_class(ary_dot, ary_color, ui_ic_channels, ui_led_cnt, ui_grp_mod, ui_grp_cnt, ui_scan_cnt, ui_mod_w, ui_mod_h) {
    // 结果数组
    var ary_end_data = new mc_pixtrace_scan_pix_data();

    ary_end_data.set_mod_msg({
        ui_ic_channels: ui_ic_channels,
        ui_scan_cnt: ui_scan_cnt,
        ui_str_cnt: ui_grp_mod * ui_grp_cnt
    });
    if (0 >= ary_dot.length) {
        ary_dot = mc_get_default_dot_data(ui_scan_cnt, ui_grp_cnt, ui_mod_w, ui_mod_h, ary_color, ui_grp_mod, ui_led_cnt);
        if (!ary_dot) {
            return false;
        }
    }

    for (var idx_str = 0; idx_str < ary_dot.length; idx_str++) {
        var ary_str = ary_dot[idx_str];

        for (var idx_scan_val = 0; idx_scan_val < ary_str.length; idx_scan_val++) {
            var ary_scan_val = ary_str[idx_scan_val];

            for (var idx_pix = 0; idx_pix < ary_scan_val.length; idx_pix++) {
                var obj_mod_point = ary_scan_val[idx_pix];

                ary_end_data.set_walk_point(obj_mod_point, idx_str, idx_scan_val);
            }
        }
    }


    return ary_end_data.get_led_data();
}


/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    获取默认走点数据
 * 参数: 参数内个属于与原函数一致
 *    @param { Promise<Number> } ui_scan_cnt
 *    @param { Promise<Number> } ui_grp_cnt
 *    @param { Promise<Number> } ui_mod_w
 *    @param { Promise<Number> } ui_mod_h
 *    @param { Promise<Array> } ary_color
 *    @param { Promise<Number> } ui_grp_mod
 *    @param { Promise<Number> } ui_led_cnt
 * 返回:
 *    @returns { Promise<Array> } 走点数据数组
 * 例子:
 *    NA
 * 备注:
 *    NA
 * 修改:
 *    1. 类型 : 修改
 *       作者 : 巫昭雯
 *       时间 : 2021-04-15
 *       内容 : 修改函数内 ui_scan_cnt * ui_grp_cnt 判断书写格式; 使用 swich 语句;
************************************************************************************************/
function mc_get_default_dot_data(ui_scan_cnt, ui_grp_cnt, ui_mod_w, ui_mod_h, ary_color, ui_grp_mod, ui_led_cnt) {
    var ary_return_data = [];
    var idx_h = 0;
    var idx_w = 0;
    var obj_dot = {};
    var idx_grp = 0;
    var ui_grp_len = ary_color.length;
    var ui_grp_idx = 0;
    var idx_grp_mod = 0;

    // 求值
    switch (ui_scan_cnt * ui_grp_cnt) {
        case ui_mod_h:
            case_equal_h();
            break;
        case ui_mod_w:
            case_equal_w();
            break;
        default:
            return false;
    }

    function case_equal_h() {
        ui_mod_h = ui_scan_cnt;
        for (idx_grp = 0; idx_grp < ui_grp_cnt; idx_grp++) {
            ui_grp_idx = idx_grp * ui_grp_len;

            for (idx_grp_mod = 0; idx_grp_mod < ui_grp_len; idx_grp_mod++) {
                if (!ary_return_data[ui_grp_idx + idx_grp_mod]) {
                    ary_return_data[ui_grp_idx + idx_grp_mod] = [];
                }
                for (idx_h = 0; idx_h < ui_mod_h; idx_h++) {
                    for (idx_w = ui_mod_w; 0 < idx_w; idx_w--) {
                        obj_dot = {
                            x: idx_w,
                            y: ((idx_h + 1) + (idx_grp * ui_scan_cnt)),
                            invalid_cnt: 0,
                            color: ary_color[(ui_grp_idx + idx_grp_mod) % ui_grp_len]
                        };
                        if (!ary_return_data[ui_grp_idx + idx_grp_mod][idx_h % ui_scan_cnt]) {
                            ary_return_data[ui_grp_idx + idx_grp_mod][idx_h % ui_scan_cnt] = [obj_dot];
                        } else {
                            ary_return_data[ui_grp_idx + idx_grp_mod][idx_h % ui_scan_cnt].push(obj_dot);
                        }
                    }
                }
            }
        }
    }

    function case_equal_w() {
        ui_mod_w = ui_scan_cnt;
        for (idx_grp = 0; idx_grp < ui_grp_cnt; idx_grp++) {
            ui_grp_idx = idx_grp * ui_grp_len;

            for (idx_grp_mod = 0; idx_grp_mod < ui_grp_len; idx_grp_mod++) {
                if (!Array.isArray(ary_return_data[ui_grp_idx + idx_grp_mod])) {
                    ary_return_data[ui_grp_idx + idx_grp_mod] = [];
                }
                for (idx_w = 0; idx_w < ui_mod_w; idx_w++) {
                    for (idx_h = ui_mod_h; 0 < idx_h; idx_h--) {
                        obj_dot = {
                            x: ((idx_w + 1) + (idx_grp * ui_scan_cnt)),
                            y: idx_h,
                            invalid_cnt: 0,
                            color: ary_color[(ui_grp_idx + idx_grp_mod) % ui_grp_len]
                        };
                        if (!Array.isArray(ary_return_data[ui_grp_idx + idx_grp_mod][(idx_w % ui_scan_cnt)])) {
                            ary_return_data[ui_grp_idx + idx_grp_mod][(idx_w % ui_scan_cnt)] = [obj_dot];
                        } else {
                            ary_return_data[ui_grp_idx + idx_grp_mod][(idx_w % ui_scan_cnt)].push(obj_dot);
                        }
                    }
                }
            }
        }
    }

    if (1 === ui_grp_mod) {
        return mc_merge_ary_by_led_cnt(ui_grp_len, ui_led_cnt, ui_grp_cnt, ary_return_data);
    }

    return ary_return_data;
}
// 获取模组颜色
function mc_quick_get_mod_color(obj_sdk_param) {
    var ui_mod_grp = Number(obj_sdk_param.get_param_value("MC_LANG_LABLE_TXGRP_MODE"));

    if (isNaN(ui_mod_grp)) {
        return false;
    }
    if (1 === ui_mod_grp) {
        ui_mod_grp = 999;
    }
    var ary_color = [];

    for (var idx_color = 1; idx_color <= ui_mod_grp; idx_color++) {
        var str_param_name = "MC_LANG_LABLE_COLOR_" + idx_color;
        var str_clr_val = obj_sdk_param.get_param_value(str_param_name);

        if (!str_clr_val) {
            break;
        }
        switch (str_clr_val) {
            case "1":
                str_clr_val = "R";
                break;
            case "2":
                str_clr_val = "G";
                break;
            case "3":
                str_clr_val = "B";
                break;
            default:
                str_clr_val = "V";
                break;
        }
        ary_color.push(str_clr_val);
    }
    if (-1 === ary_color.indexOf("R") && -1 === ary_color.indexOf("G") && -1 === ary_color.indexOf("B")) {
        parent.mc_alert_popout("MC_LANG_MC_SET_MOD_CLR_ERR");
        return false;
    }
    return ary_color;
}
// 如果串行 根据颜色数量,灯珠数数量合并
function mc_merge_ary_by_led_cnt(ui_grp_len, ui_led_cnt, ui_grp_cnt, ary_end_data) {
    var ary_return = [];

    // 循环数据组数,区分N条线
    for (var idx_str = 0; idx_str < ui_grp_cnt; idx_str++) {
        var ui_str_idx = idx_str * ui_grp_len;
        var ui_str_len = ary_end_data[0].length;

        ary_return.push([]);
        // 循环单条线长度(因为所有线必须对齐,所以可以直接根据单线长度来进行排序)
        for (var idx_scan = 0; idx_scan < ui_str_len; idx_scan++) {
            var ary_scan_data = ary_end_data[idx_str * ui_grp_len][idx_scan];

            for (var idx_pix = 0; idx_pix < ary_scan_data.length; idx_pix += ui_led_cnt) {
                // 根据灯珠数获取每条线上的X个点,以X个点为一组进行排序
                for (var idx_led_len = 0; idx_led_len < ui_grp_len; idx_led_len++) {
                    // 取排序数据X个点来排序
                    for (var idx_led_cnt = 0; idx_led_cnt < ui_led_cnt; idx_led_cnt++) {
                        var obj_point_data = ary_end_data[ui_str_idx + idx_led_len][idx_scan][idx_pix + idx_led_cnt];

                        if (!Array.isArray(ary_return[idx_str][idx_scan])) {
                            ary_return[idx_str][idx_scan] = [];
                        }
                        if (!obj_point_data) {
                            ary_return[idx_str][idx_scan].push(null);
                            continue;
                        }
                        ary_return[idx_str][idx_scan].push(obj_point_data);
                    }
                }
            }
        }
    }

    return ary_return;
}
// 获取模组名称 如果模组已存在放回false
function mc_get_module_name(obj_sdk_module, ary_mod_data) {
    if (!Array.isArray(ary_mod_data) || 0 >= ary_mod_data.length) {
        return "MC_MOD_0";
    }
    var ui_name_max = 0;

    for (var idx_mod = 0; idx_mod < ary_mod_data.length; idx_mod++) {
        var str_mod_json = ary_mod_data[idx_mod].data.mc_util_mod_get_xml();
        var str_module_name = ary_mod_data[idx_mod].name;
        var ui_mod_name_num = Number(str_module_name.match(/\d+/g)[0]);

        if (ui_mod_name_num > ui_name_max) {
            ui_name_max = ui_mod_name_num;
        }
        if (obj_sdk_module.mc_util_mod_check_equal(str_mod_json)) {
            parent.mc_alert_popout("MC_LANG_MOD_EXIST");
            return false;
        }
    }
    return "MC_MOD_" + (ui_name_max + 1);
}

/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    解析模组信息,生成字串,存入模组数据数组中
 * 参数:
 *    @param {promises<String>} str_module_msg 模组基本信息
 *    @param {promises<string>} str_info_msg 芯片注册信息
 *    @param {promises<string>} str_undate_mod_name 更新模组名称
 *    @param {promises<Array>} ary_mod_data 模组数据数组
 *    @param {promises<Array>} ary_dot 页面数据(没有的话使用默认走点)
 *    @param {promises<Boolean>} b_is_more 走点模式(多线/单线)
 *    @param {promises<Array>} ary_use_mod_name 已知箱体及所使用模组名称列表
 * 返回：
 *    @returns {Promise<Boolean>} 修改结果
 * 备注:
 *   因为多线走点与单线走点生成的数据不同,但结果数据相同,故使用此函数统一化,将数据修改相同
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 徐烁超
 *      时间 : 2020.5.6
 *      内容 : 所有代码
 ************************************************************************************************/
function mc_modwizd_update_module_xml(str_module_msg, str_info_msg, str_undate_mod_name, ary_mod_data, ary_dot, b_is_more) {
    var obj_sdk_param = new mc_sdk_param();

    if (!obj_sdk_param.set_json(str_module_msg)) {
        parent.mc_alert_popout("MC_LANG_MC_SET_MOD_SIZE_ERR");
        return false;
    }
    var ui_update_mod_idx = mc_modwizd_get_idx_by_name(ary_mod_data, str_undate_mod_name);
    var obj_update_mod = ary_mod_data[ui_update_mod_idx].data;

    // 模组宽度
    var ui_mod_w = Number(obj_sdk_param.get_param_value("MC_LANG_LABLE_WEITH"));
    // 模组高度
    var ui_mod_h = Number(obj_sdk_param.get_param_value("MC_LANG_LABLE_HEIGHT"));
    // 模组设置的行扫数
    var ui_scan_cnt = Number(obj_sdk_param.get_param_value("MC_LANG_LABLE_SCAN_CNT"));
    // 模组数据组数
    var ui_grp_cnt = Number(obj_sdk_param.get_param_value("MC_LANG_LABLE_TXGRP_CNT"));
    // 模组数据组类型
    var ui_grp_mod = Number(obj_sdk_param.get_param_value("MC_LANG_LABLE_TXGRP_MODE"));
    // 获取模组颜色
    var ary_color = mc_quick_get_mod_color(obj_sdk_param);

    if (!ary_color) {
        parent.mc_alert_popout("MC_LANG_MC_SET_MOD_SIZE_ERR_BLACK_MOD");
        return false;
    }
    var obj_rect = obj_update_mod.mc_util_mod_get_img_rect(0, 0xffffffff);
    var ui_update_mod_w = (obj_rect.u32_right + 1 - obj_rect.u32_left);
    var ui_update_mod_h = (obj_rect.u32_bottom + 1 - obj_rect.u32_top);
    // 更新模组分组模式
    var ui_update_grp_mod = Number(obj_update_mod.mc_util_mod_get_str_grp_mode());
    // 获取数据组类型
    var ui_grp_type = Number(obj_sdk_param.get_param_value("MC_LANG_LABLE_LED_GRP_MODE"));
    // 获取时钟数量
    var ui_clock_cnt = mc_modwizd_get_mod_clock_cnt(obj_sdk_param);
    // 获取模组灯珠数,只有串行模式使用
    var ui_update_led_cnt = ui_clock_cnt * ui_grp_type;
    // 获取更新模组颜色
    var ary_update_mod_clr = obj_update_mod.mc_util_mod_get_clr_msg();
    var ui_grp_type_loc = obj_update_mod.mc_util_mod_get_led_type();
    var ui_clock_cnt_loc = obj_update_mod.mc_util_mod_get_sclk_pin_cnt();
    var ui_led_cnt = ui_grp_type_loc * ui_clock_cnt_loc;

    if (
        (Array.isArray(ary_dot) && 0 < ary_dot.length) ||
        ui_scan_cnt !== obj_update_mod.mc_util_mod_get_max_scan_cnt() ||
        ui_grp_cnt !== (obj_update_mod.mc_util_mod_get_str_cnt() / ui_update_grp_mod) ||
        ui_update_mod_w !== ui_mod_w ||
        ui_update_mod_h !== ui_mod_h ||
        ui_update_grp_mod !== ui_grp_mod ||
        ui_update_led_cnt !== ui_led_cnt
    ) {
        return mc_use_msg_set_module_xml(str_module_msg, str_info_msg, ary_mod_data, str_undate_mod_name, ary_dot, b_is_more);
    }
    if (!mc_modwizd_set_mod_msg(obj_sdk_param, obj_update_mod, str_info_msg)) {
        parent.mc_alert_popout("MC_LANG_MC_SET_MOD_SIZE_ERR_UPDATE_MOD_INFO");
        return false;
    }


    if (
        !mc_modwizd_compare_clr(ary_update_mod_clr, ary_color)
    ) {
        mc_modwizd_dispose_point_to_loc(obj_update_mod, ary_color, ary_update_mod_clr);
    }
    for (var idx_mod = 0; idx_mod < ary_mod_data.length; idx_mod++) {
        if (ui_update_mod_idx === idx_mod) {
            continue;
        }
        var str_mod_json = ary_mod_data[idx_mod].data.mc_util_mod_get_xml();

        if (obj_update_mod.mc_util_mod_check_equal(str_mod_json)) {
            parent.mc_alert_popout("MC_LANG_MOD_EXIST");
            return false;
        }
    }
    return true;
}
/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    存入模组基本信息
 * 参数:
 *    @param {promises<Object>} obj_mod_param mc_sdk_param实例对象
 *    @param {promises<Object>} obj_update_mod mc_sdk_module实例对象
 *    @param {promises<String>} str_info_msg 显示芯片注册信息字符串
 * 返回：
 *   @returns {Boolean} 存入结果
 * 备注:
 *   NA
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 徐烁超
 *      时间 : 2020.5.6
 *      内容 : 所有代码
 ************************************************************************************************/
function mc_modwizd_set_mod_msg(obj_mod_param, obj_update_mod, str_info_msg) {
    // 模组数据组类型
    var ui_grp_mod = Number(obj_mod_param.get_param_value("MC_LANG_LABLE_TXGRP_MODE"));
    // 显示芯片名称
    var str_dispchip_name = obj_mod_param.get_param_value("MC_LANG_DISPCHIP_LIST");
    // 行管芯片名称
    var str_scan_chip_name = obj_mod_param.get_param_value("MC_LANG_SCANCHIP_LIST");
    // CLOSE有效性
    var str_close_vaild = Number(obj_mod_param.get_param_value("MC_LANG_LABLE_CLOSE_LOW_VALID"));
    // OE有效性
    var str_oe_vaild = Number(obj_mod_param.get_param_value("MC_LANG_LABLE_OE_LOW_VALID"));
    // TX有效性
    var str_tx_vaild = Number(obj_mod_param.get_param_value("MC_LANG_LABLE_TX_LOW_VALID"));
    // 模组宽度
    var ui_mod_w = Number(obj_mod_param.get_param_value("MC_LANG_LABLE_WEITH"));
    // 模组高度
    var ui_mod_h = Number(obj_mod_param.get_param_value("MC_LANG_LABLE_HEIGHT"));
    // 数据组类型
    var ui_grp_type = Number(obj_mod_param.get_param_value("MC_LANG_LABLE_LED_GRP_MODE"));
    // 获取模组颜色
    var ary_color = mc_quick_get_mod_color(obj_mod_param);
    // 模组设置的行扫数
    var ui_scan_cnt = Number(obj_mod_param.get_param_value("MC_LANG_LABLE_SCAN_CNT"));


    // 存入 显示 / 行管芯片名称 模组分组模式
    obj_update_mod.mc_util_mod_set_str_grp_mode(ui_grp_mod);
    obj_update_mod.mc_util_mod_set_disp_chip(str_dispchip_name);
    obj_update_mod.mc_util_mod_set_scan_chip(str_scan_chip_name);
    obj_update_mod.mc_util_mod_set_width(ui_mod_w);
    obj_update_mod.mc_util_mod_set_height(ui_mod_h);
    obj_update_mod.mc_util_mod_set_led_type(ui_grp_type);
    obj_update_mod.mc_util_mod_set_clr_msg(ary_color);
    obj_update_mod.mc_util_mod_set_scan_cnt(ui_scan_cnt);

    if ("string" !== typeof obj_mod_param.get_param_value("MC_LANG_LABLE_OE_LOW_VALID")) {
        str_oe_vaild = true;
    }
    obj_update_mod.mc_util_mod_set_oe_low_valid(str_oe_vaild);
    obj_update_mod.mc_util_mod_set_tx_low_valid(str_tx_vaild);
    obj_update_mod.mc_util_mod_set_close_low_valid(str_close_vaild);
    // 存入时钟
    obj_update_mod.mc_util_mod_set_sclk_pin_name(0, "SCLK");
    var ui_param_cnt = obj_mod_param.get_param_cnt();

    for (var idx_clock = 2; idx_clock < ui_param_cnt; idx_clock++) {
        var str_clock_val = obj_mod_param.get_param_value(("MC_LANG_LABLE_SCLK_" + idx_clock));

        if ("MC_LANG_OPTION_NOT_USE" === str_clock_val) {
            break;
        }
        obj_update_mod.mc_util_mod_set_sclk_pin_name((idx_clock - 1), str_clock_val);
    }
    var obj_info_param = new mc_sdk_param();

    if (!obj_info_param.set_json(str_info_msg)) {
        return false;
    }
    var ui_step_val = 1;
    var ui_jump_ic = Number(obj_info_param.get_attr_val(str_dispchip_name, "JUMP_IC"));

    if (1 === ui_jump_ic) {
        ui_step_val = Number(obj_info_param.get_attr_val(str_dispchip_name, "IC_CHANNELS"));
    }
    obj_update_mod.mc_util_mod_set_scan_pix_step(ui_step_val);
    return true;
}
/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    解析sdk_module走点数据,修改为内部识别数据
 * 参数:
 *    @param {promises<Object>} obj_update_mod mc_sdk_module实例对象
 *    @param {promises<Array>} ary_clr 颜色
 *    @param {promises<Array>} ary_update_mod_clr 更新前模组颜色
 * 返回：
 *   NA
 * 备注:
 *   NA
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 徐烁超
 *      时间 : 2020.9.8
 *      内容 : 所有代码
 ************************************************************************************************/
function mc_modwizd_dispose_point_to_loc(obj_update_mod, ary_clr, ary_update_mod_clr) {
    if ("function" !== typeof obj_update_mod.mc_util_mod_get_str_ary) {
        return;
    }
    var ary_update_point = obj_update_mod.mc_util_mod_get_str_ary();

    if (0 >= ary_update_point.length) {
        return;
    }

    for (var idx_grp = 0; idx_grp < ary_update_point.length; idx_grp++) {
        var obj_str_data = ary_update_point[idx_grp];
        var ary_str_val = obj_str_data.vst_scan_ary;

        for (var idx_str = 0; idx_str < ary_str_val.length; idx_str++) {
            var obj_scan_val = ary_str_val[idx_str];
            var ary_scan__val = obj_scan_val.vst_pix_ary;

            for (var idx_scan = 0; idx_scan < ary_scan__val.length; idx_scan++) {
                var obj_pix_val = ary_scan__val[idx_scan];

                mc_modwizd_updata_mod_color(obj_pix_val, ary_clr, ary_update_mod_clr);
            }
        }
    }
}

// 更新模组颜色(对比更新前颜色,更换为更新后对应位置颜色)
function mc_modwizd_updata_mod_color(obj_point_data, ary_updata_clr, ary_update_mod_clr) {
    var ary_old_clr = ary_update_mod_clr;
    var str_old_color = obj_point_data.c_color;
    var ui_old_color_idx = ary_old_clr.indexOf(str_old_color);

    if ("V" === str_old_color) {
        return;
    }
    if (-1 === ui_old_color_idx) {
        parent.mc_alert_popout("ERROR:color");
        throw new Error("module color get");
    }
    obj_point_data.c_color = ary_updata_clr[ui_old_color_idx];
}

/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    判断颜色是否不同
 * 参数:
 *    @param {promises<Array>} ary_update_mod_clr 更新模组颜色
 *    @param {promises<Array>} ary_color 选中模组颜色
 * 返回：
 *   @returns {Boolean} 模组颜色是否相同
 * 备注:
 *   NA
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 徐烁超
 *      时间 : 2020.5.6
 *      内容 : 所有代码
 ************************************************************************************************/
function mc_modwizd_compare_clr(ary_update_mod_clr, ary_color) {
    if (ary_update_mod_clr.length !== ary_color.length) {
        return false;
    }
    var b_clr_same = true;

    for (var idx_clr = 0; idx_clr < ary_update_mod_clr.length; idx_clr++) {
        if (ary_update_mod_clr[idx_clr] !== ary_color[idx_clr]) {
            b_clr_same = false;
            break;
        }
    }
    return b_clr_same;
}

/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    模组应用流程
 * 参数:
 *    @param {promises<String>} str_mod_msg 模组信息字串
 *    @param {promises<Array>} ary_mod_data 模组数据数组
 *    @param {promises<Array>} ary_box_data 箱体数据数组
 *    @param {promises<String>} str_info_json 注册信息字串
 *    @param {promises<String>} str_undate_mod_name 修改模组名称
 *    @param {promises<Array>} ary_dot_msg 已知走点数据
 *    @param {promises<Boolean>} b_go_mc 走点模式(多线走点/单线走点)
 *    @param {promises<String>} str_ctrlchip_hub_date 主控芯片HUB接口数据
 * 返回：
 *   @returns {Promise<String>} 当前模组名称
 * 备注:
 *   NA
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 徐烁超
 *      时间 : 2020.5.6
 *      内容 : 所有代码
 ************************************************************************************************/
function mc_wizard_apply_flow(str_mod_msg, ary_mod_data, ary_box_data, str_info_json, str_undate_mod_name, ary_dot_msg, b_go_mc, str_ctrlchip_hub_date) {
    var obj_mod_msg = new mc_sdk_param();

    if (!obj_mod_msg.set_json(str_mod_msg)) {
        return false;
    }
    var str_ctrlchip_name = obj_mod_msg.get_param_value("MC_LANG_CTRLCHIP_LIST");
    var str_hub_name = obj_mod_msg.get_param_value("MC_LANG_LABLE_HUB");

    var str_mod_name = "";

    if ("string" !== typeof str_undate_mod_name || 0 >= str_undate_mod_name.length) {
        str_mod_name = mc_use_msg_set_module_xml(str_mod_msg, str_info_json, ary_mod_data, "", ary_dot_msg, b_go_mc);
    } else {
        str_mod_name = str_undate_mod_name;
        if (!mc_modwizd_update_module_xml(str_mod_msg, str_info_json, str_undate_mod_name, ary_mod_data, ary_dot_msg, b_go_mc)) {
            return false;
        }
    }

    if (!str_mod_name) {
        return false;
    }
    var str_box_json = "";

    //如果创建模组时箱体信息为空时创建一个基本箱体
    if (0 === ary_box_data.length) {
        // parent.g_str_ctrl_name = str_ctrlchip_name;
        mc_modwizd_access_set_box_file(str_ctrlchip_name, str_hub_name, str_mod_name, str_mod_msg, ary_mod_data, ary_box_data, str_ctrlchip_hub_date);
        var box_name = ary_box_data[0].name;

        str_box_json = mc_layout_get_box_basic(box_name, ary_box_data, ary_mod_data);

        parent.get_box_info(true, str_box_json);
        // 记录使用模组名称
        var obj_mod_name = {
            name: "MC_BOX_0",
            use_mod_name: [str_mod_name]
        };

        parent.ARY_USE_MOD_NAME.push(obj_mod_name);
    }
    // 构建侧边模组信息
    if (str_undate_mod_name) {
        // 修改侧边箱体信息
        str_box_json = mc_layout_get_box_basic(parent.SELECT_BOX_NAME, ary_box_data, ary_mod_data);

        parent.update_side_info(str_box_json, parent.ui_box_cur_page);
        parent.get_mod_info(false);
        // 更新侧栏大屏SIZE
        parent.mc_update_screen_size(parent.SELECT_BOX_NAME);
    } else {
        parent.get_mod_info(true);
    }

    parent.UI_EDIT_JUMP = -1;
    // 切换常规页面
    parent.STR_PAGE_PATH = "../pages/box_main/box_main.html";
    parent.update_lang_display();
    return str_mod_name;
}

/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    更新箱体芯片信息
 * 参数:
 *    @param {promises<String>} str_box_name 箱体名称
 *    @param {promises<Array>} ary_box_data 已知走点数据
 *    @param {promises<String>} str_ctrlchip_hub_date 主控芯片HUB接口数据
 * 返回：
 *   NA
 * 备注:
 *   NA
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 徐烁超
 *      时间 : 2020.12.1
 *      内容 : 所有代码
 ************************************************************************************************/
function mc_modwizd_updata_box_chip(str_box_name, ary_box_data, str_ctrlchip_hub_date) {
    var ui_box_idx = mc_modwizd_get_idx_by_name(ary_box_data, str_box_name);

    if ("number" !== typeof ui_box_idx) {
        return;
    }
    var obj_box_data = ary_box_data[ui_box_idx].data;

    ary_box_data[ui_box_idx].ctrlchip_hub_msg = str_ctrlchip_hub_date;
    var obj_box_msg = obj_box_data.mc_util_get_ui_box_msg();

    var obj_sdk_param = new mc_sdk_param();

    obj_sdk_param.set_json(str_ctrlchip_hub_date);
    var str_ctrl_name = obj_sdk_param.get_param_value("MC_LANG_CTRLCHIP_LIST");
    var str_hub_name = obj_sdk_param.get_param_value("MC_LANG_LABLE_HUB");

    obj_box_msg.ctrlchip_name = str_ctrl_name;
    obj_box_msg.hub_name = str_hub_name;
    if (obj_box_msg.edit_val && 0 !== Object.keys(obj_box_msg.edit_val).length) {
        // 修改dsp描述信息的名称
        obj_box_msg.edit_val.str_name = str_hub_name;
    }
}
